source /mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/env_volcengine.sh

# 读取命令行参数
DATA_NAME="suzuki_60" # 存放数据集的名字
MODEL_NAME="suzuki_60" # 模型名称
# if [ -z "./train_regression/${DATA_NAME}" ]; then
#     echo "Error: DATA_NAME environment variable is required"
#     exit 1W
# fi

# 检查所需路径是否都存在
PROJECT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS"
CHECKPOINT_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/ChemBOMAS_results/share/llama-3.1-8B/clustered/suzuki_60"
SAVE_RESULTS_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/ChemBOMAS_results"

required_paths=(
    "/mnt/shared-storage-user/caipengxiang/H200-share/models/share/step1_llama3_8b_0916_yearly_pistachio_ep3"
    "${PROJECT_DIR}/train_regression/data4regression"
    "yield_ft_ds_config.json"
    "${SAVE_RESULTS_DIR}"
)

for path in "${required_paths[@]}"; do
    if [ ! -e "$path" ]; then
        echo "Error: Required path not found: $path"
        exit 1
    fi
done

export TOKENIZERS_PARALLELISM=false #Disable parallelism to avoid deadlocks
# export NVIDIA_TF32_OVERRIDE=0 #Disable the auto-conversion from NVIDIA PF32 to TF32 

# torchrun --nnodes=${NNODES} \
#             --node_rank=${RANK} \
#             --nproc_per_node=${GPUS_PER_NODE} \
#             --master_addr=${MASTER_ADDR} \
#             --master_port=${MASTER_PORT} \

deepspeed --num_nodes=${NNODES} \
            --num_gpus=${GPUS} \
            --master_addr=${MASTER_ADDR} \
            --master_port=${MASTER_PORT} \
            --node_rank=${RANK} \
            inference_tongji_wetlab_formal.py \
            --pretrained_model_path "/mnt/shared-storage-user/caipengxiang/H200-share/models/share/step1_llama3_8b_0916_yearly_pistachio_ep3" \
            --searchspace_name "suzuki_60" \
            --lora 1 \
            --data_name ${DATA_NAME} \
            --checkpoint_dir "${CHECKPOINT_DIR}" \
            --load_by_torch 1 \
            --save_path "${SAVE_RESULTS_DIR}" \