source /mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/env_volcengine.sh

# suzuki_50
# arylation
# buchwald_Cc1ccc(Nc2ccc(C(F)(F)F)cc2)cc1.csv
# buchwald_Cc1ccc(Nc2ccccn2)cc1.csv
# buchwald_Cc1ccc(Nc2cccnc2)cc1.csv
# buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv
# buchwald_COc1ccc(Nc2ccc(C)cc2)cc1.csv

# 读取命令行参数
DATA_NAME="suzuki_50" # 存放数据集的名字
# DATA_NAME="grouped_exp" # 存放数据集的名字

CHECKPOINT_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Exp_AB_results/share/llama-3.1-8B/clustered/${DATA_NAME}"
BASE_MODEL_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/ChemBOMAS_Models/MolT5-Large"
SAVE_RESULTS_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Exp_AB_results"
latest="_molt5_large : only sft"


# 检查所需路径是否都存在
PROJECT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS"

NOTES="cluster_config/method_notes.txt"

required_paths=(
    "${BASE_MODEL_DIR}"
    "${PROJECT_DIR}/train_regression/data4regression"
    "yield_ft_ds_config.json"
    "${SAVE_RESULTS_DIR}"
    "${NOTES}"
)

echo $latest

for path in "${required_paths[@]}"; do
    if [ ! -e "$path" ]; then
        echo "Error: Required path not found: $path"
        exit 1
    fi
done
# exit 0
export TOKENIZERS_PARALLELISM=false #Disable parallelism to avoid deadlocks
# export NVIDIA_TF32_OVERRIDE=0 #Disable the auto-conversion from NVIDIA PF32 to TF32 

# torchrun --nnodes=${NNODES} \
#             --node_rank=${RANK} \
#             --nproc_per_node=${GPUS_PER_NODE} \
#             --master_addr=${MASTER_ADDR} \
#             --master_port=${MASTER_PORT} \

deepspeed --num_nodes=${NNODES} \
            --num_gpus=${GPUS} \
            --master_addr=${MASTER_ADDR} \
            --master_port=${MASTER_PORT} \
            --node_rank=${RANK} \
            molt5_eval.py \
            --pretrained_model_path ${BASE_MODEL_DIR} \
            --searchspace_name ${DATA_NAME} \
            --lora 1 \
            --data_name ${DATA_NAME} \
            --batch_size 48 \
            --checkpoint_dir ${CHECKPOINT_DIR} \
            --log_file "exp_eval.log" \
            --pooling_method "last_token" \
            --cluster_config "cluster_config/cluster_config.yaml" \
            --load_by_torch 0 \
            --latest_method_notes "${latest}" \
            --buchwald_all 1
