source /mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/env_volcengine.sh

# 读取命令行参数
DATA_NAME="suzuki_60_new_prompt" # 存放数据集的名字
MODEL_NAME="suzuki_60_new_prompt" # 模型名称

CHECKPOINT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/share/llama-3.1-8B/clustered/suzuki_60_new_prompt"

# BASE_MODEL_DIR="/tos-bjml-ai4phys/shared/checkpoints/models--meta-llama--Meta-Llama-3.1-8B/snapshots/d04e592bb4f6aa9cfee91e2e20afa771667e1d4b"
BASE_MODEL_DIR="/mnt/shared-storage-user/caipengxiang/H200-share/models/share/step1_llama3_8b_0916_yearly_pistachio_ep3"

# if [ -z "./train_regression/${DATA_NAME}" ]; then
#     echo "Error: DATA_NAME environment variable is required"
#     exit 1W
# fi

# 检查所需路径是否都存在
PROJECT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS"

required_paths=(
    "${BASE_MODEL_DIR}"
    "${PROJECT_DIR}/train_regression/data4regression"
    "yield_ft_ds_config.json"
)

for path in "${required_paths[@]}"; do
    if [ ! -e "$path" ]; then
        echo "Error: Required path not found: $path"
        exit 1
    fi
done

export TOKENIZERS_PARALLELISM=false #Disable parallelism to avoid deadlocks
# export NVIDIA_TF32_OVERRIDE=0 #Disable the auto-conversion from NVIDIA PF32 to TF32 

# torchrun --nnodes=${NNODES} \
#             --node_rank=${RANK} \
#             --nproc_per_node=${GPUS_PER_NODE} \
#             --master_addr=${MASTER_ADDR} \
#             --master_port=${MASTER_PORT} \

deepspeed --num_nodes=${NNODES} \
            --num_gpus=${GPUS} \
            --master_addr=${MASTER_ADDR} \
            --master_port=${MASTER_PORT} \
            --node_rank=${RANK} \
            eval_model.py \
            --pretrained_model_path ${BASE_MODEL_DIR} \
            --searchspace_name ${DATA_NAME} \
            --lora 1 \
            --data_name ${DATA_NAME} \
            --batch_size 32 \
            --checkpoint_dir ${CHECKPOINT_DIR} \
