#!/bin/bash
#SBATCH -p AI4Phys
#SBATCH --job-name=ligand
#SBATCH --output=ligand-emb.output
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=16
#SBATCH --gres=gpu:1
#SBATCH --verbose 

echo "SLURM job ID: $SLURM_JOB_ID"

python save_ligand_embs.py \
   --pretrained_model_path '/mnt/hwfile/ai4chem/share/step1_llama3_8b_0916_yearly_pistachio_ep3' \
   --lora_adapter_path "/mnt/hwfile/ai4chem/chenjianpeng/train_regression/llama_ep3_1115-18/lora_adapter" \
   --save_root './eval_results/ligand_embs/' \
   --data_path '/mnt/hwfile/ai4chem/share/jianpeng_code/train_regression/data4molecular/' \
   --data_name 'ligand' \
   --batch_size 4 \
   --use_lora 1 \
   --state_dict_path /mnt/hwfile/ai4chem/share/jianpeng_code/train_regression/trained_models/train_regression_fg_changes_600/390-149-0.5400004386901855\
   --log_file "save_ligand_embs_yields.log" \
   --load_ds_ckpt_id 390-149-0.5400004386901855

