source /mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/env_volcengine.sh


# crossed_barrel
# dye_lasers
# lnp3
# perovskites
# redoxmers


# 读取命令行参数
DATA_NAME="redoxmers" # 存放数据集的名字

# 检查所需路径是否都存在
BASE_MODEL_PATH="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Llama-3.1-8B"

PROJECT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS"
CHECKPOINT_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Sci_results/share/llama-3.1-8B/clustered/${DATA_NAME}"

SAVE_RESULTS_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Sci_results"

required_paths=(
    "${BASE_MODEL_PATH}"
    "${PROJECT_DIR}/train_regression/data4regression"
    "yield_ft_ds_config.json"
    "${SAVE_RESULTS_DIR}"
)

for path in "${required_paths[@]}"; do
    if [ ! -e "$path" ]; then
        echo "Error: Required path not found: $path"
        exit 1
    fi
done

export TOKENIZERS_PARALLELISM=false #Disable parallelism to avoid deadlocks
# export NVIDIA_TF32_OVERRIDE=0 #Disable the auto-conversion from NVIDIA PF32 to TF32 

# torchrun --nnodes=${NNODES} \
#             --node_rank=${RANK} \
#             --nproc_per_node=${GPUS_PER_NODE} \
#             --master_addr=${MASTER_ADDR} \
#             --master_port=${MASTER_PORT} \

deepspeed --num_nodes=${NNODES} \
            --num_gpus=${GPUS} \
            --master_addr=${MASTER_ADDR} \
            --master_port=${MASTER_PORT} \
            --node_rank=${RANK} \
            inference_tongji_wetlab_formal.py \
            --pretrained_model_path ${BASE_MODEL_PATH} \
            --searchspace_name ${DATA_NAME} \
            --lora 1 \
            --data_name ${DATA_NAME} \
            --batch_size 48 \
            --checkpoint_dir "${CHECKPOINT_DIR}" \
            --load_by_torch 0 \
            --save_path "${SAVE_RESULTS_DIR}" \
