- 对比结果分析

如图[图示占位符，例如`\ref{fig:comparison}`]所示，结果表明ChemBOMAS在关键性能指标上始终优于其他方法。

\begin{fig}
\ref{fig:comparison}
\caption{四个数据集上的对比实验结果。(a)(b)(c)(d)分别表示Suzuki~4数据集，在大部分数据集上ChemBOMAS的初始值都远高于其他方法，仅在reaction-1上初始值略低，在所有数据集上CHemBOMAS的收敛速度和最优解都元高于其他方法}

就初始性能而言，ChemBOMAS在首次迭代中实现了最高的平均“最佳值”，彰显其在缓解冷启动问题方面的有效性。在Arylaton~4上，得益于Fine-Optimization模块中生成的高质量的伪数据辅助，ChemoBOMAS的初始值均显著高于其他方法,特别的，在初始轮就能达到95%Best的效果。在所有数据集上，ChemBOMAS的收敛速度都远快于其他方法，且最优值也特别高，特别是在reaction-1上，在第三轮就迅速收敛到最佳，且此时ChemBOMAS的最优值是96.15%，是当前搜索空间中的全局最优值，而其他方法的最好效果也仅仅达到了83.19%。同时，可以观察到ChemBOMAS优化过程中方差极小，体现了非常强大的稳健性。这是因为，在初始轮时，ChemBOMAS会基于已有的先验数据以及生成的伪数据共同计算采集函数，这相当于极大的增加了先验数据的规模，因此在短迭代过程中，整体的波动会非常小。ChemBOMAS在短迭代中就能找到全局最优解（搜索空间中的最大值），因此即使在长迭代中也几乎没有方差。在长迭代过程中，ChemBOMAS会逐步丢弃生成的伪数据，使用真实值替换，因此避免了部分错误的伪数据对整个优化过程的阻碍，使得ChemBOMAS能很快就优化到最优值并收敛。例如在Buchwald$_\text{sub-1}$数据集中，ChemBOMAS仅在第13轮就收敛到最优解80.90%产率，而其他方法最快也在第23轮才获得较优值79.76%产率，该结果明显劣于ChemBOMAS的推荐结果。

可以发现ChemBOMAS在Arylaton,3,4上的优势没有Suzuki这么明显，我们推测为，ChemBOMAS在Fine-Optimization阶段需要有充足的数据进行训练，而由于初始轮中我们仅能使用1%的数据作为先验，伪数据的质量相对较低，导致初始轮的优化效果受到限制。同时，Suzuki的数据量要远多于其他三个数据集，因此在Suzuki上，ChemBOMAS可以有更多的数据用于训练。

3. 消融实验

为了研究每个模块的作用.....

- Fine-Optimization模块

| Dataset   | Model Setting             | MSE         | MAE         | R2           |
| --------- | ------------------------- | ----------- | ----------- | ------------ |
| reaction-1    | only pretrain without sft | 2407.22168  | 40.27201843 | -2.054122925 |
| reaction-1    | w/o pre and sft           | 2338.017578 | 39.43235779 | -1.966321468 |
| reaction-1    | no pretrain but sft       | 685.5507813 | 20.50312233 | 0.130218744  |
| reaction-1    | Full                      | 633.6779785 | 19.47443199 | 0.19603157   |
| reaction-2 | only pretrain without sft | 1853.701416 | 33.24118042 | -1.487995863 |
| reaction-2 | w/o pre and sft           | 1797.880005 | 32.53952026 | -1.41307354  |
| reaction-2 | no pretrain but sft       | 679.7202148 | 19.57245445 | 0.087695003  |
| reaction-2 | Full                      | 650.0027466 | 19.54961014 | 0.12758106   |
| reaction-grouped  | only pretrain without sft | 1795.716431 | 32.52443314 | -1.411040306 |
| reaction-grouped  | w/o pre and sft           | 1881.9552   | 33.72668076 | -1.526829958 |
| reaction-grouped  | no pretrain but sft       | 739.2731323 | 20.565382   | 0.007405937  |
| reaction-grouped  | Full                      | 667.1643677 | 19.51274872 | 0.104223669  |


这一部分研究了伪数据预测部分。在这一模块中，我们分别尝试了去掉Pretrain环节、去掉SFT环节，以及两个都去掉，分别进行了测试，使用MSE, MAE, R2作为评估指标，结果如表格所示\cite{}
这里，由于Buchwald$_\text{sub-1}$, Buchwald$_\text{sub-2}$属于同一反应体系，因此在训练、评估的过程中，将两个数据集合并，统称为reaction-grouped

表格结果非常直观的表明，使用SFT非常关键，可以大幅提高R2，强化模型的产率预测能力。比较有意思的一个结论是，只使用Pretrain而不使用SFT的效果，反而不如直接使用基准模型。我们认为这是因为，仅仅进行pretrain，会让模型更加熟悉smiles式，但是模型难以将smiles与真实产率直接的映射关系学习到，导致模型过度关于每个反应物的smiles本身，而难以掌握反应变量与产率之间的映射。但对比使用pretrain后进行sft，与直接进行sft，两者的结果显示，在pretrain后进行sft，模型对于反应变量与产率的映射关系学习的更加准确，对于产率的预测更加精确，这说明pretrain阶段模型学习到的化学知识对于产率预测是很有帮助的，但是需要sft进行引导，在pretrain的基础上再进行微调效果会提升更多

## Coarse Optimization模块
我们按照知识的相关性，依次去掉了多源信息检索中的RAG,Database,Websearch部分，然后根据聚类结果进行bayes optim，对比结果，如表格所示\ref{}。

Dataset	Variant	Best Found	Inital Value	95% Max Iter	Iteration of Best
Reaction-1	full	86.38 	68.96 	13	37
Reaction-1	w/o ref	92.91 	75.07 	36	37
Reaction-1	w/o ref+db	96.15 	72.98 	5	5
Reaction-1	w/o all	82.95 	71.35 	12	31
Reaction-2	full	79.73 	78.71 	1	30
Reaction-2	w/o ref	79.64 	78.71 	1	4
Reaction-2	w/o ref+db	81.64 	74.11 	10	14
Reaction-2	w/o all	79.70 	74.11 	6	21
Reaction-3	full	79.53 	78.77 	1	37
Reaction-3	w/o ref	79.35 	78.77 	1	37
Reaction-3	w/o ref+db	79.83 	79.31 	1	37
Reaction-3	w/o all	79.67 	79.31 	1	31
Reaction-4	full	56.81 	38.77 	2	2
Reaction-4	w/o ref	56.81 	38.77 	2	2
Reaction-4	w/o ref+db	56.81 	56.81 	1	1
Reaction-4	w/o all	56.81 	56.81 	1	1



- 完整消融

在上面我们系统研究了两个模块中各个组分的影响，这里分析两个模块的影响。在这里我们尝试分别去掉两个模块后，对比优化效果，结果如表格所示。

4. 参数分析实验

- 每轮采样数

这里我们测试了每轮采样数是否会对ChemBOMAS造成很大的影响。我们分别按照整个数据集体量的0.05%, 0.1%, 0.2%, 0.4%设置，由于Buchwald$_\text{sub-1}$,4数据集的数据量很少，在1%时已经小于1（四舍五入取1），因此0.05%下无法进行实验

结果如表格：

Dataset	Batch Percentage	Batch Size	Best Found	Initial Value	Time	Iteration of Best Found
Suzuki	0.05%	3	96.15 	72.98 	105.18 	3
Suzuki	0.10%	5	96.15 	72.98 	158.03 	3
Suzuki	0.20%	10	96.15 	72.98 	318.11 	3
Suzuki	0.40%	20	96.15 	72.98 	646.02 	3
Arylaton	0.05%	2	80.67 	78.71 	59.24 	37
Arylaton	0.10%	3	80.64 	78.71 	95.01 	39
Arylaton	0.20%	6	81.65 	78.71 	240.63 	39
Arylaton	0.40%	12	81.25 	78.71 	755.86 	29
Buchwald$_\text{sub-1}$	0.05%	-	-	-	-	-
Buchwald$_\text{sub-1}$	0.10%	1	79.58 	75.55 	10.51 	25
Buchwald$_\text{sub-1}$	0.20%	2	79.39 	75.55 	24.43 	23
Buchwald$_\text{sub-1}$	0.40%	4	79.60 	75.55 	56.30 	25
Buchwald$_\text{sub-2}$	0.05%	-	-	-	-	-
Buchwald$_\text{sub-2}$	0.10%	1	56.81 	53.34 	8.77 	2
Buchwald$_\text{sub-2}$	0.20%	2	56.81 	53.34 	20.57 	2
Buchwald$_\text{sub-2}$	0.40%	4	56.81 	53.34 	49.02 	2



可以发现，随着batch size变化，整体的表现会得到一定提升，但提升非常小，这说明ChemBOMAS可以仅依靠非常少的数据，且每轮仅采样非常少的数据点，就能找到变量空间中的最优组合方案。特别的，对于Suzuki,4两个数据集，得益于伪数据的高质量，即使batch size剧烈变化，模型都能在初始轮的时候根据先验数据+伪数据的组合，稳定的找到一个确定的较大值。可以观察到Suzuki,4的标准差非常非常小，这是因为在初始轮时，模型已经获取先验数据以及伪数据，而不会进行随机采样，因此标准差很小，模型的稳健性质非常大。

随着batch增大，模型的运行时长也随之增大，在最优解提升不明显的情况下，我们选择了0.1%作为batch size

- 先验数据量

这一部分我们研究了先验数据量的影响。我们设定了0.25%, 0.5%, 1.0%, 2.0%, 4.0%五个层级，分别对预训练后的LLM进行微调，得出以下数据
Dataset		MSE	MAE	R2
Reaction-1	0.25	1205.188354	27.7989521	-0.528316498
Reaction-1	0.5	774.7037964	21.12675285	0.017713785
Reaction-1	1	633.6779785	19.47443199	0.19603157
Reaction-1	2	479.0892334	15.92473507	0.391138315
Reaction-1	4	360.0204163	13.44487667	0.540699363
Dataset		MSE	MAE	R2
Reaction-2	0.25	793.9162598	24.20370674	-0.065418124
Reaction-2	0.5	1016.370789	26.53459167	-0.363307118
Reaction-2	1	650.0027466	19.54961014	0.12758106
Reaction-2	2	462.5153503	15.75197983	0.380197704
Reaction-2	4	286.5636902	11.96577168	0.616613388
Dataset		MSE	MAE	R2
Reaction-g	0.25	737.6404419	23.5041008	0.009922266
Reaction-g	0.5	617.279541	19.81219482	0.171246409
Reaction-g	1	593.7609863	18.51830292	0.202779531
Reaction-g	2	365.5960693	13.98419857	0.509799004
Reaction-g	4	248.4382172	11.28229809	0.666072607

很直观的变化就是，随着数据量变多，整体趋势是变好的。我们发现1%的时候，reaction-1,2的R2都是首次超过0.0，而且三个数据集上R2都在0.2附近，于是我们选择了1%作为先验数据的数据量

由于0.25%, 0.5%的时候，Reaction-1,2 上模型预测的R2小于0，因此我们忽略了这一部分，分别使用1%,2%,4%训练出的模型权重进行伪数据推理，然后用于贝叶斯优化，效果的对比，结果如表格：

Dataset	Scale Percentage	Scale Size	Best Found	Inital Value	Iteration of Best
Reaction-1	1%	50	88.98 	65.95 	37
Reaction-1	2%	100	88.99 	70.25 	36
Reaction-1	4%	200	91.41 	52.13 	40
Reaction-2	1%	30	79.67 	45.98 	40
Reaction-2	2%	60	81.65 	48.95 	40
Reaction-2	4%	120	83.81 	37.11 	31
Reaction-3	1%	7	79.63 	54.07 	31
Reaction-3	2%	14	79.56 	41.14 	39
Reaction-3	4%	28	80.91 	32.36 	15
Reaction-4	1%	7	56.81 	12.87 	11
Reaction-4	2%	14	53.95 	15.59 	38
Reaction-4	4%	28	53.93 	16.22 	40


很明显发现，随着数据规模倍数增大，Bayes Optim的效果却并没有很大的提升，甚至在部分情况下1%的效果更优。

---

# 补充材料

## 数据集可视化

[这里绘制了Suzuki~4的产率KDE可视化图]

以下是所用的四个数据集的介绍

=== 基础统计信息 Suzuki ===
总数据量: 5030
最大值: 96.1461333003187
最小值: 0.0
均值: 33.04
中位数: 26.86
标准差: 22.47
25% 分位数: 15.26
75% 分位数: 51.27

=== 基础统计信息 Arylaton ===
总数据量: 3678
最大值: 84.64975432
最小值: 0.0
均值: 29.05
中位数: 25.53
标准差: 23.79
25% 分位数: 6.87
75% 分位数: 47.14

=== 基础统计信息 Buchwald$_\text{sub-1}$ ===
总数据量: 629
最大值: 80.90631241
最小值: 0.0
均值: 42.24
中位数: 42.21
标准差: 22.86
25% 分位数: 23.14
75% 分位数: 63.01

=== 基础统计信息 Buchwald$_\text{sub-2}$ ===
总数据量: 765
最大值: 56.80622374
最小值: 0.0
均值: 18.71
中位数: 11.34
标准差: 18.98
25% 分位数: 0.72
75% 分位数: 38.77

## Fine-Optimization模块中Base Model选择分析实验

这里我们尝试了使用不同的LLM作为base model，尝试了LLaMa-3.1-8B, Qwen3-8B, GLM-4-9B进行对比，直接进行sft后对比三种模型的MSE, MAE, R2

这里，由于Buchwald$_\text{sub-1}$, Buchwald$_\text{sub-2}$属于同一反应体系，因此在训练、评估的过程中，将两个数据集合并，统称为reaction-grouped

大致结论为：Qwen3效果最不好，在数据集上的R2都小于0；LLaMa在Suzuki上的表现相对较差，低于GLM，但是在reaction-2上表现优于GLM-4。同时，比较两个表现差异，LLaMa在reaction-2上比GLM-4高了十倍，而reaction-1上劣势只是两倍。综合来看，LLaMa表现要更好一点

此外，我们尝试直接使用闭源模型(不sft，直接预测产率)，或开源的在科学数据集上预训练的模型（进行sft），进行产率预测，结果进行评估。

所有的结果如下：
		MSE	MAE	R2
suzuki	LLaMA-3.1-8B	685.55 	20.50 	0.13 
suzuki	Qwen3-7B	820.48 	22.10 	-0.04 
suzuki	GLM4-9B	593.49 	18.94 	0.25 
suzuki	GPT-5	1218.93 	30.34 	-0.55 
suzuki	GPT-4o	2207.17 	40.02 	-1.80 
suzuki	MolT5-Large	1081.23 	25.13 	-0.37 
suzuki	Galactica-1.3B	569.50 	18.86 	0.28 
arylation	LLaMA-3.1-8B	679.72 	19.57 	0.09 
arylation	Qwen3-7B	848.51 	22.52 	-0.14 
arylation	GLM4-9B	739.20 	20.78 	0.01 
arylation	GPT-5	1515.81 	33.68 	-1.04 
arylation	GPT-4o	2702.58 	44.86 	-2.63 
arylation	MolT5-Large	1094.86 	25.40 	-0.47 
arylation	Galactica-1.3B	785.01 	21.83 	-0.05 
Buchwald	LLaMA-3.1-8B	739.27 	20.57 	0.01 
Buchwald	Qwen3-7B	998.22 	25.25 	-0.34 
Buchwald	GLM4-9B	719.72 	20.77 	0.00 
Buchwald	GPT-5	1516.62 	33.55 	-1.04 
Buchwald	GPT-4o	1512.44 	33.60 	-1.03 
Buchwald	MolT5-Large	1098.16 	25.37 	-0.47 
Buchwald	Galactica-1.3B	857.79 	22.54 	-0.15 


## 数据规模分析

分别使用0%, 0.25%, 0.5%, 1.0%, 2.0%, 4.0%的规模进行微调，LLM使用LLaMa，得出以下结论：随着数据规模增加，模型性能得到大幅提升，当数据规模来到1%时，在Suzuki, Arylaton上的R2首次超过0，而在reaction-grouped上在0.5%时高于0，在1%时继续获得小幅提升。这里我们为了测试ChemBOMAS在少样本上的优化能力（少样本数更加接近真实湿实验场景），因此统一选用了1%的数据作为已知的先验数据

## 其他学科数据集

## 与人类专家对比

我们邀请了6位化学领域的专家，对四个数据集中的物质进行了聚类，然后使用固定的伪数据，进行了优化效果对比，BO表示传统贝叶斯：

Dataset	Method	Best Found	Inital Value	95% Max Iter	Iteration of Best
Reaction-1	Expert	96.15 	61.96 	3	3
Reaction-1	BO	83.16 	54.04 	16	38
Reaction-1	ChemBOMAS	96.15 	72.98 	3	3
Reaction-2	Expert	79.67 	78.71 	1	36
Reaction-2	BO	80.45 	64.64 	8	35
Reaction-2	ChemBOMAS	82.23 	78.71 	1	39
Reaction-3	Expert	79.71 	75.55 	2	32
Reaction-3	BO	78.86 	45.39 	26	31
Reaction-3	ChemBOMAS	79.77 	75.55 	2	11
Reaction-4	Expert	56.81 	53.33 	2	2
Reaction-4	BO	56.29 	27.96 	13	34
Reaction-4	ChemBOMAS	56.81 	56.81 	1	1

可以看到我们的方法超过了人类专家

## 湿实验验证

## 