# ICLR 2026 Artifact for Adaptive Reinforcement Learning for Unobservable Random Delays

It is assumed the user has access to a UNIX-style terminal that includes the
programs `conda`, `tar`, and (optionally) `git`.

This directory contains the following:

 * `appendix.pdf`: The appendix to the original PDF submission.
 * `latency-env/`: The code base with the ACDA, BPQL and SAC implementations as
                   well as the simulated interaction layer.
 * `latency-env/_logs`: The collected results used to generate the plots and
                        tables in the paper.
 * `vdpo/`: The original VDPO artifact with the interaction layer and noisy
            actions added. This was used to generate the VDPO results presented
            in the paper. A full transcript of the changes from the original
            artifact is provided in the accompanying patch file.
 * `vdpo.patch`: The changes applies to the original VDPO repository. Cloning
                 from https://github.com/QingyuanWuNothing/VDPO.git, checking
                 out the commit `6949511139437ba9bc65bc526b426db803e5b587`, and
                 then applying this patch with `git apply` will result in the
                 same contents as the `vdpo/` directory.
 * `dreamer/`: The original Dreamer v3 artifact with the interaction layer and
               noisy actions added. This was used to generate the Dreamer
               results presented in the paper. A full transcript of the changes from the original artifact is provided in the
               accompanying patch file.
 * `dreamer.patch`: The changes applies to the original Dreamer v3 repository.
                    Cloning from https://github.com/danijar/dreamerv3.git,
                    checking out the commit
                    `cdf570902b1eaba193cc8ef69426cd4edde1b0bc`, and
                    then applying this patch with `git apply` will result in
                    the same contents as the `dreamer/` directory.
 * `dcac/`: The original DCAC artifact with noisy actions and our delay
            processes added. This was used to generate the DCAC results
            presented in the paper. A full transcript of the changes from the
            original artifact is provided in the accompanying patch file.
 * `dcac.patch`: The changes applies to the original DCAC repository. Cloning
                 from https://github.com/rmst/rlrd.git, checking out the commit
                 `dd4f71516543d9886f9ad5287c5fe5eca466f3b3`, and then applying
                 this patch with `git apply` will result in the same contents
                 as the `dcac/` directory.
