


def align_lineparts(lineparts):
    """Input: [(Parts...)], Output: String"""
    maxpartlengths = []
    for lp in lineparts:
        for i, p in enumerate(lp):
            if i >= len(maxpartlengths):
                maxpartlengths.append(len(p))
            else:
                maxpartlengths[i] = max(maxpartlengths[i], len(p))
    lines = []
    for lp in lineparts:
        if len(lp) == 0:
            line = ""
        else:
            line = " ".join([lp[0]] + [
                " "*(maxpartlengths[i] - len(lp[i])) + p
                for i, p in enumerate(lp[1:])
            ])
        lines.append(line)
    return "\n".join(lines)

