#!/usr/bin/env python3

import argparse
import json
import re
import sys

parser = argparse.ArgumentParser("Reads DCAC text output from stdin, puts eval JSON to stdout.")
parser.add_argument("-D", "--delay-name", "--latency-name",
                    dest="latency_name", type=str,
                    required=True)
parser.add_argument("--spr", "--steps-per-round",
                    dest="steps_per_round", type=int,
                    default=2000)

args = parser.parse_args()

output_json = {
    "args": None, # This is foreign results, so not applicable...
    "trainer_prefix": "DCAC", # not used either really...
    "evaluations": [],
}

memlines = []
cur_epoch = None
cur_round = None

def parse_memlines():
    global memlines, cur_epoch, cur_round
    if cur_epoch is None:
        assert len(memlines) == 0
        return

    test_avg = None
    test_std = None
    for l in memlines:
        if l.startswith("returns_test"):
            test_avg = float(l.split()[1])
        elif l.startswith("return_std_test"):
            test_std = float(l.split()[1])

    if test_avg is not None:
        cur_iterations = ((cur_epoch - 1) * 50 + cur_round) * args.steps_per_round
        if len(output_json["evaluations"]) > 0:
            assert output_json["evaluations"][-1]["iterations"] == (cur_iterations - args.steps_per_round)

        output_json["evaluations"].append({
            "iterations": cur_iterations,
            "latency_eval": {
                args.latency_name: {
                    "return_avg": test_avg,
                    "return_std": test_std,
                }
            }
        })

    memlines = []


p = re.compile(r"^=== epoch (\d+:?)/10 [=]+ round (\d+:?)/50 ===")
for l in sys.stdin.readlines():
    l = l.strip().lower()
    m = p.match(l)
    if m is not None:
        # New round
        parse_memlines()
        cur_epoch = int(m.group(1))
        cur_round = int(m.group(2))
    elif cur_epoch is not None:
        memlines.append(l)

parse_memlines()

json.dump(output_json, sys.stdout, indent=4)
