#!/usr/bin/env python3

import argparse
import json
import sys

parser = argparse.ArgumentParser("Reads DreamerV3 text output from stdin, puts eval JSON to stdout.")
parser.add_argument("-D", "--delay-name", "--latency-name",
                    dest="latency_name", type=str,
                    required=True)

args = parser.parse_args()

output_json = {
    "args": None, # This is foreign results, so not applicable...
    "trainer_prefix": "DreamerV3", # not used either really...
    "evaluations": [],
}

memlines = []
for l in sys.stdin.readlines():
    if l.strip() == "":
        continue
    e = json.loads(l)
    if not "eval/return/avg" in e:
        continue

    output_json["evaluations"].append({
        "iterations": e["step"],
        "latency_eval": {
            args.latency_name: {
                "return_avg": e["eval/return/avg"],
                "return_std": e["eval/return/std"],
                "length_avg": e["eval/eplen/avg"],
                "length_std": e["eval/eplen/std"],
            }
        }
    })

json.dump(output_json, sys.stdout, indent=4)
