#!/usr/bin/env python3

import argparse
import json
import sys

parser = argparse.ArgumentParser("Reads VDPO text output from stdin, puts eval JSON to stdout.")
parser.add_argument("-D", "--delay-name", "--latency-name",
                    dest="latency_name", type=str,
                    required=True)

args = parser.parse_args()

output_json = {
    "args": None, # This is foreign results, so not applicable...
    "trainer_prefix": "VDPO", # not used either really...
    "evaluations": [],
}

memlines = []
for l in sys.stdin.readlines():
    l = l.strip()
    if len(memlines) > 0:
        memlines.append(l)
        if l.endswith("]}"):
            s = "\n".join(memlines)
            e = json.loads(s)
            output_json["evaluations"].append({
                "iterations": e["global_step"],
                "latency_eval": {
                    args.latency_name: {
                        "returns": e["eval_re"],
                        "lengths": [-1]*len(e["eval_re"])
                    }
                }
            })
            memlines = []
    else:
        if l.startswith("{\"global_step\":"):
            memlines.append(l)

json.dump(output_json, sys.stdout, indent=4)
