import gymnasium as gym
import numpy as np
import scipy.stats
from rich import print
from collections import deque

from interaction_layer import (
    NoisyActionWrapper,
    SimulatedInteractionLayer,
    ActionMemorizer, # Constant-Delay Augmentation
    delay_from_string,
)

def make_mujoco_env(env_name, seed):
    env = gym.make(env_name)
    env = NoisyActionWrapper(env)
    env.action_space.seed(seed)
    env.observation_space.seed(seed)
    return env

def make_delayed_mujoco_env(env_name, seed, delay, delayspec):
    env = gym.make(env_name)
    env = NoisyActionWrapper(env)
    # The "delay" parameter becomes the assumed upper bound delay. The true
    # delay process is specified by "delayspec".
    assumed_delay = delay
    true_delay_process = delay_from_string(delayspec)
    print("Created Delay Process:", str(true_delay_process))
    env = SimulatedInteractionLayer(env, delay=true_delay_process, horizon=assumed_delay)
    env = ActionMemorizer(env, horizon=assumed_delay, obs_passthrough=True)
    env.action_space.seed(seed)
    env.observation_space.seed(seed)
    return env
