#   Copyright (c) 2020 PaddlePaddle Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Save inference model."""

import argparse

import paddle
import paddle.fluid as fluid

import knover.models as models
import knover.tasks as tasks
from knover.utils import check_cuda, parse_args


def setup_args():
    """Setup saving arguments."""
    parser = argparse.ArgumentParser()

    models.add_cmdline_args(parser)
    tasks.add_cmdline_args(parser)

    parser.add_argument("--inference_model_path", type=str, required=True)

    args = parse_args(parser)
    args.run_infer = True # only build infer program
    args.display()
    return args


def save(args):
    """Save inference model."""
    gpu_id = 0
    place = fluid.CUDAPlace(gpu_id)

    task = tasks.create_task(args)
    model = models.create_model(args, place)
    model.save_inference_model(args.inference_model_path)
    return


if __name__ == "__main__":
    paddle.enable_static()
    args = setup_args()
    check_cuda(True)
    save(args)
