experiment_name='fusion-without-prompt'

CUDA_VISIBLE_DEVICES=0 fairseq-train ./data/pretrain/ \
  --arch fusion \
  --task fusion \
  --criterion fusion \
  --num-workers 1 \
  --max-tokens 1024 \
  --seed 43 \
  --skip-invalid-size-inputs-valid-test \
  --lr-scheduler inverse_sqrt \
  --lr 1e-4 \
  --log-interval 100 \
  --warmup-init-lr 1e-07 \
  --stop-min-lr 1e-09 \
  --fp16 \
  --fp16-init-scale 4 \
  --optimizer adam \
  --adam-betas '(0.9, 0.98)' \
  --warmup-updates 2000 \
  --update-freq 16 \
  --save-interval-updates 2000 \
  --user-dir ./esm \
  --save-dir ./dump/ckpt/$experiment_name \
  --tensorboard-logdir ./dump/log/$experiment_name \
  --max-epoch 201
