# On Injecting Noise During Inference
We study the impact of activation noise in a generative energy-based modeling setting during training for the purpose of regularization. We prove that activation noise is a general form of dropout. Then, we analyze the role of activation noise at inference time and demonstrate it to be utilizing sampling. Thanks to the activation noise we observe about 200% improvement in performance (classification accuracy). Later, we not only discover, but also prove that the best performance is achieved when the activation noise follows the same distribution both during training and inference. To explicate this phenomenon, we provide theoretical results that illuminate the roles of activation noise during training, inference, and their mutual influence on the performance. To further confirm our theoretical results, we conduct experiments for five datasets and seven random variable distributions.

<!--
Worth mentioning that some of the results shall be reproduced in one run/stage while more complicated ones require two runs/stages where at the first run the data is produced and the second one reproduces the results in the form of figures.
-->

## Reproduce Figure 2
First, via running the following script we can create the folder `fig2Table1` and its contents (the data pertaining to Figure 2) with which later reproducing Figure 2 becomes viable.

```
./make_data_fig2.py
```
Then to draw the figure the following script must be run:

```
./draw_fig2.py
```
## Reproduce Table 1
By running the following script the data of Table 1 will be reproduced.

```
./make_data_tab1.py
```

The following command will produce the table:

```
./make_tab1.py
```

## Reproduce Figure 3
Again, we start by making the data pertaining to Figure 2 by running the following script:

```
./make_data_fig3.py
```

Then via running the following script the figure will be reproduced.

## Reproduce Figure 4
The following script reproduces Figure 4:

```
./draw_fig4.py
```
## Reproduce Figure 5

This reproduction is again double-stage where first the data is produced and later the figure. Accodingly, the following scripts must be run consequtively:

- `./make_data_fig5.py`
- `./draw_fig5.py`

## Reproducing the Rest of the Results

Run the followings:

- Table 2: `./make_tab1.py`
- Figure 6: `./make_data_fig6.py` and then `./draw_fig6.py`
- Figure 7: `./make_data_fig7.py` and then `./draw_fig7.py`
- Figure 8: `./make_data_fig8.py` and then `./draw_fig8.py`
- Figure 9: `./make_data_fig9.py` and then `./draw_fig9.py`
- Table 5: `./make_data_tab5.py` and then `./draw_tab2.py`
- Figure 10: `./make_data_fig10.py` and then `./draw_fig10.py`





