import argparse



def checkattr(args, attr):
    '''Check whether attribute exists, whether it's a boolean and whether its value is True.'''
    return hasattr(args, attr) and type(getattr(args, attr))==bool and getattr(args, attr)



def define_args(filename, description):
    parser = argparse.ArgumentParser('./{}.py'.format(filename), description=description)
    return parser


def add_options(parser):

    parser.add_argument('--no-save', action='store_false', dest='save', help="don't save trained models")
    parser.add_argument('--test', action='store_false', dest='train', help='evaluate previously saved model')
    parser.add_argument('--seed', type=int, default=11, help='random seed (for each random-module used)')
    # parser.add_argument('--no-gpus', action='store_false', dest='cuda', help="don't use GPUs")
    parser.add_argument('--data-dir', type=str, default='./store/datasets', dest='d_dir', help="default: %(default)s")
    parser.add_argument('--model-dir', type=str, default='./store/models', dest='m_dir', help="default: %(default)s")
    parser.add_argument('--plot-dir', type=str, default='./store/plots', dest='p_dir', help="default: %(default)s")
    parser.add_argument('--results-dir', type=str, default='./store/results', dest='r_dir', help="default: %(default)s")
    parser.add_argument('--eval-s', type=int, default=1000, dest='num_samples', help="number of samples")
    parser.add_argument('--epoch-n', type=int, default=200, dest='num_epochs', help="number of epochs")
    parser.add_argument('--learning-rate', type=int, default=0.004, help="the learning rate")
    parser.add_argument('--train-noise', type=float, default=0.9, help="the amplitude of noise during training")
    parser.add_argument('--test-noise', type=float, default=0.9, help="the amplitude of noise during test")
    parser.add_argument('--no-model-summary', action='store_false', dest='mprint', help="don't print the summary of model architecture")
    parser.add_argument('--no-gpus', action='store_false', dest='cuda', help="don't use GPUs")

    return parser

def set_defaults(args):


    args.num_classes = 10
    args.verbose = True
    args.dataset = "CIFAR10"
    args.folder_name = "fig2"
    args.counter = "counter-fig2"
    args.result = "result-fig2"
    args.num_of_seeds = 10
    args.train_noise_range = 20
    args.test_noise_range = 20
    args.file_directory_counter = args.folder_name + "/" + args.counter  + ".npy"
    args.file_directory_result = args.folder_name + "/" + args.result  + ".npy"
    args.distribution = "Gaussian"


    return args

