# main.py
import time
from config import TrainingConfig
from train import train

def main():
    tsp = time.time()
    print(tsp)
    tsp = time.strftime("%Y-%m-%d-%H-%M-%S", time.localtime(tsp))

    # Configuration
    config = TrainingConfig(
        h=128,
        look_back_window=512*2,
        T=720*2,
        batch_size=8,
        max_scale=3.5,
        model_name='ViTime',
        epochs=2000,
        root_path='your root path',
        model_path='model',
        d_norm=1,
        memory_test_mode=True,
        temperature=1,
        cycle_time=1,
        deep_cycle_time=1,
        load_history=False,
        patch_size=(4, 32),
        kernel_size=(31, 31),
        random_cut=True,
        model_size=0.75,
        loss_type='JSD',
        name=f'ViTime_{tsp}',
        downsample_factor=8,
        num_workers=8,
        curve=False,
        set_syn_data_type='all',
        scal=2,
        model_extend=True,
        more_random=True,
        mu_norm=2,
    )

    # Train model
    train(config)

if __name__ == "__main__":
    main()