import copy

def filter_table(resources, table):
    table = copy.deepcopy(table)

    max_time = resources.get_time()
    max_data = resources.get_data()
    max_memory = resources.get_memory()

    table = list(sorted(table, key=lambda x: x['time'], reverse=True))
    table = list(filter(lambda x: x['time'] <= max_time, table))
    table = list(filter(lambda x: x['data'] <= max_data, table))
    table = list(filter(lambda x: x['memory'] <= max_memory, table))

    return table[0]['keep_factor']