## Video Structure

This repository organizes evaluation videos for different experiments and settings. The directory layout mirrors tasks, robot platforms, and outcomes (success/failure) using a consistent naming scheme.

### Naming convention
- Files follow: `<Agent>-<Scenario/Task>-<Outcome>_<Index>.mp4`
- **Agent** examples: `XR-1`, `pi0`, `DP`
- **Outcome** examples: `suc` (success), `fail` (failure)
- Task/scenario details are embedded in the middle section of the filename.

## 1) Main Experiments

We selected two robotic platforms for the main experiment, with two tasks chosen for each platform—resulting in a total of four tasks. For every individual task, XR-1 provides a video demonstrating successful task execution, while pi0 offers a corresponding video showing failed task execution.

- **UR dual-arm (XR-1 vs pi0)**
  - Path: `main/ur_dual/`
  - Tasks:
    - `ur_01_stack_the_blue_cube/`
      - `XR-1-ur_01_stack_the_blue_cube-suc.mp4` (XR-1 success)
      - `pi0-ur_01_stack_the_blue_cube-fail.mp4` (pi0 failure)
    - `ur_03_trans_buttons/`
      - `XR-1-ur_03_trans_buttons-suc.mp4` (XR-1 success)
      - `pi0-ur_03_trans_buttons-fail.mp4` (pi0 failure)
- **Tienkung 2.0 (XR-1 vs pi0)**
  - Path: `main/tienkung_pro2/`
  - Tasks:
    - `find_out_packaging_tape_into_the_other_box/`
      - `XR-1-find_out_packaging_tape_into_the_other_box-suc.mp4` (XR-1 success)
      - `pi0-find_out_packaging_tape_into_the_other_box-fail.mp4` (pi0 failure)
    - `stack_the_cup/`
      - `XR-1-stack_the_cup-suc_2.mp4` (XR-1 success)
      - `pi0-stack_the_cup-fail_7.mp4` (pi0 failure)


## 2) Generalization Experiments

We provide videos demonstrating XR-1's generalization capabilities across various dimensions for two tasks. Specifically, one successful XR-1 video is included for each generalization setting, with the particular generalization type clearly encoded in the filename.



- Path: `generalization/`
  - `DFR-SweepTrash/`
    - `XR-1-Base-suc_4.mp4`
    - `XR-1-Unseen_Dustpan-suc_6.mp4`
    - `XR-1-Unseen_Rubbish-suc_7.mp4`
    - `XR-1-Unseen_Rubbish+Dynamic_Object_Interference-suc_9.mp4`
  - `DFR-TransferCup/`
    - `XR-1-Base-suc_1.mp4`
    - `XR-1-Unseen_Cup+Static_Object_Interference-suc_3.mp4`
    - `XR-1-Unseen_Cup+Unseen_Background-suc_3.mp4`
    - `XR-1-Unseen_Cup+Unseen_Background+Unseen_Light-suc_11.mp4`

## 3) OOB (Out-of-Box) Experiment

One task with one XR-1 success video and one corresponding pi0 failure video. XR-1 uses the out-of-box setting, while pi0 is fine-tuned.

- Path: `OOB/`
  - `XR-1-OOB-franka_dr3_stack_the_bowl-suc_2.mp4` (XR-1 success)
  - `pi0-franka_dr3_stack_the_bowl-fail_3.mp4` (pi0 failure)

## 4) Few-shot Experiment

One task with one XR-1 success video and one DP failure video. Both XR-1 and DP use the few-shot setting.

- Path: `few-shot/`
  - `XR-1-few_shot-find_out_circuit_breaker_into_the_other_tray-suc_5.mp4` (XR-1 success)
  - `DP-few_shot-find_out_circuit_breaker_into_the_other_tray-fail_1.mp4` (DP failure)
