#!/bin/bash
in_dir="LibriSpeech/dev-clean"
out_dir="LibriSpeech/dev-clean-wav"

total=$(find "$in_dir" -type f -name "*.flac" | wc -l)
count=0

find "$in_dir" -type f -name "*.flac" -print0 | while IFS= read -r -d '' f; do
    count=$((count+1))
    relpath="${f#$in_dir/}"
    out="$out_dir/${relpath%.flac}.wav"
    mkdir -p "$(dirname "$out")"
    echo "[$count/$total] Converting: $f -> $out"
    ffmpeg -y -i "$f" -ar 16000 -ac 1 "$out" >/dev/null 2>&1
done
