# Copyright (c) 2024, NVIDIA CORPORATION.  All rights reserved.
#
# NVIDIA CORPORATION and its licensors retain all intellectual property
# and proprietary rights in and to this software, related documentation
# and any modifications thereto.  Any use, reproduction, disclosure or
# distribution of this software and related documentation without an express
# license agreement from NVIDIA CORPORATION is strictly prohibited.

#!/bin/bash

source activate ffcv_env 

pip install pytest
pip install prettytable
pip install terminaltables
pip install fastargs
pip install pandas
pip install pyyaml
pip install tqdm
pip install schedulefree
pip install airbench
pip install pyhessian
pip install timm
pip install --upgrade git+https://github.com/noahgolmant/pytorch-hessian-eigenthings.git@master#egg=hessian-eigenthings
pip install tensorboard
pip install wandb
pip install scikit-learn
pip install opencv-python

# Install the latest versions
pip install --upgrade transformers datasets accelerate tokenizers bitsandbytes
pip install --upgrade torch torchvision torchaudio
pip install --upgrade huggingface_hub
pip install --upgrade sentencepiece  # Required for some tokenizers
pip install black fire 
pip install gradio

# export MASTER_ADDR="localhost"
# export MASTER_PORT=$((10000 + RANDOM % 50000))
# export WORLD_SIZE=4  # Number of GPUs

export TOKENIZERS_PARALLELISM=false
export PYTORCH_DISABLE_DISTRIBUTED_DTENSOR=1

# CUDA_VISIBLE_DEVICES=0,1,2,3 python finetune_ham.py \
accelerate launch --multi_gpu --mixed_precision=fp16 ./finetune_ham.py \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --data_path './commonsense_170k.json' \
    --output_dir DoRA/commonsense_reasoning/llama3_1B_LoRA_HAM_5/ \
    --wandb_run_name "llama3_1B_LoRA_HAM_run_5" \
    --batch_size 16  --micro_batch_size 2 --num_epochs 3 \
    --learning_rate 2e-4 --cutoff_len 256 --val_set_size 120 \
    --eval_step 80 --save_step 80  --adapter_name lora \
    --target_modules '["q_proj", "k_proj", "v_proj", "up_proj", "down_proj"]' \
    --lora_r 32 --lora_alpha 64 --use_gradient_checkpointing


CUDA_VISIBLE_DEVICES=0 python ./commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset boolq \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/boolq.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset piqa \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/piqa.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset social_i_qa \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/social_i_qa.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset hellaswag \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/hellaswag.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset winogrande \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/winogrande.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset ARC-Challenge \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/ARC-Challenge.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset ARC-Easy \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/ARC-Easy.txt

CUDA_VISIBLE_DEVICES=0 python commonsense_evaluate.py \
    --model LLaMA3-1B \
    --adapter LoRA \
    --dataset openbookqa \
    --base_model 'meta-llama/Llama-3.2-1B' \
    --batch_size 1 \
    --lora_weights ./llama3_1B_LoRA_HAM_5|tee -a ./llama3_1B_LoRA_HAM_5/openbookqa.txt
