# GNN+: Unlocking the Potential of Classic GNNs for Graph-level Tasks
[![arXiv](https://img.shields.io/badge/arXiv-2502.09263-b31b1b.svg)](https://arxiv.org/abs/2502.09263) 

[![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/graph-property-prediction-on-ogbg-ppa)](https://paperswithcode.com/sota/graph-property-prediction-on-ogbg-ppa?p=unlocking-the-potential-of-classic-gnns-for) [![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/graph-classification-on-malnet-tiny)](https://paperswithcode.com/sota/graph-classification-on-malnet-tiny?p=unlocking-the-potential-of-classic-gnns-for) [![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/graph-classification-on-cifar10-100k)](https://paperswithcode.com/sota/graph-classification-on-cifar10-100k?p=unlocking-the-potential-of-classic-gnns-for) [![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/graph-regression-on-peptides-struct)](https://paperswithcode.com/sota/graph-regression-on-peptides-struct?p=unlocking-the-potential-of-classic-gnns-for) [![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/node-classification-on-cluster)](https://paperswithcode.com/sota/node-classification-on-cluster?p=unlocking-the-potential-of-classic-gnns-for) [![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/unlocking-the-potential-of-classic-gnns-for/node-classification-on-coco-sp)](https://paperswithcode.com/sota/node-classification-on-coco-sp?p=unlocking-the-potential-of-classic-gnns-for)

Based on the GPS codebase: https://github.com/rampasek/GraphGPS

### Python environment setup with Conda

Tested with Python 3.9/3.10, PyTorch 2.2.0, and PyTorch Geometric 2.3.1.

To set up the environment, run the following commands:
```bash
conda create -n tunedGNN python=3.10
conda activate tunedGNN

pip install torch==2.2.0 torchvision==0.17.0 torchaudio==2.2.0 --index-url https://download.pytorch.org/whl/cu118
pip install torch_geometric==2.3.1
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.2.0+cu118.html

pip install scikit-learn==1.4.0
pip install fsspec rdkit
pip install pytorch-lightning yacs torchmetrics
pip install networkx
pip install tensorboardX
pip install ogb
pip install wandb
```


### Running Training

To execute training, activate the environment and run the following commands:

```bash
conda activate tunedgnn
sh run.sh 0 ppa 2 > ppa.txt 2>&1 &
sh run.sh 1 code2 1 > code2.txt 2>&1 &
sh run.sh 2 pcba 2 > pcba.txt 2>&1 &
```

Alternatively, use the following format for executing training runs:

```bash
conda activate tunedgnn

python main.py --cfg configs/gatedgcn/ppa.yaml --repeat 2 seed 0 
python main.py --cfg configs/gatedgcn/hiv.yaml --repeat 2 seed 0 
```

## Reference

If you find our codes useful, please consider citing our work

```
@article{luo2025unlocking,
  title={Unlocking the Potential of Classic GNNs for Graph-level Tasks: Simple Architectures Meet Excellence},
  author={Luo, Yuankai and Shi, Lei and Wu, Xiao-Ming},
  journal={arXiv preprint arXiv:2502.09263},
  year={2025}
}
```
