from torch_geometric.graphgym.register import register_config
from yacs.config import CfgNode as CN


@register_config('custom_gnn')
def custom_gnn_cfg(cfg):
    """Extending config group of GraphGym's built-in GNN for purposes of our
    CustomGNN network model.
    """

    # Use residual connections between the GNN layers.
    cfg.gnn.residual = True
    cfg.gnn.ffn = True
    # ham
    cfg.ham = CN()
    cfg.ham.enable = False
    cfg.ham.HK1 = 0
    cfg.ham.HK2 = 0.0
