import numpy as np
from sympy.ntheory.multinomial import multinomial_coefficients

def subsets_k(collection, k): yield from partition_k(collection, k, k)
    
def partition_k(collection, min, k):
    if len(collection) == 1:
        yield [ collection ]
        return
    
    first = collection[0]
    for smaller in partition_k(collection[1:], min - 1, k):
        if len(smaller) > k: 
            continue
    # insert `first` in each of the subpartition's subsets
        if len(smaller) >= min:
            for n, subset in enumerate(smaller):
                yield smaller[:n] + [[ first ] + subset]  + smaller[n+1:]
    # put `first` in its own subset 
        if len(smaller) < k: yield [ [ first ] ] + smaller

def get_isserlis_partitions(arr): 
    d = len(arr)
    h = int(d/2)
    isserlis_indices=[]
    for p in subsets_k(arr,h):
        #print(p)
        Flag = False
        for i in range(h):
            if len(p[i]) !=2:
                Flag =True
        if Flag == False:
            p = np.array(p)
            #p=p[p[:,0].argsort()]            
            isserlis_indices.append(p)
    
    return np.array(isserlis_indices,dtype=np.int32)