import numpy as np

def get_monomial_exponents(d, M):
    exponents = []
    for n in range(M+1):
        exponents.append(np.array(list(all_compositions(n, d))))
    return np.vstack(exponents).astype(np.int64)


def all_compositions(n, k):
    
    t = n
    h = 0
    a = [0]*k
    a[0] = n
    yield tuple(a)
    while a[k-1] != n:
        if t != 1:
            h = 0
        t = a[h]
        a[h] = 0
        a[0] = t-1
        a[h+1] += 1
        h += 1
        yield tuple(a)

        
def get_multinomial_exponents_and_coefficients(d,degree):
    def multinomial(exponents):
        res, i = 1, np.sum(exponents)
        i0 = np.argmax(exponents)    
        for a in np.hstack([exponents[:i0] ,exponents[i0+1:]]):
            for j in range(1,a+1):
                res *= i
                res //= j
                i -= 1
        return res

    multinomial_exponents= np.array(list(all_compositions(degree, d)))
    multinomial_coefficients= np.array([multinomial(m) for m in multinomial_exponents])
    return multinomial_exponents, multinomial_coefficients


def combine_count_split(arr, shape):
    t_mm = np.zeros(shape=shape, dtype=np.int32)
    #t_mm_count = np.zeros(shape[0])
    indices = {}  # collections.OrderedDict()
    for t_m in arr:
        a = np.array(["".join(t) for t in t_m])
        a.sort()
        s = ":".join(a)
        try:
            indices[s] += 1
        except:
            indices[s] = 1
    k = 0
    #print(indices)
    for keys in indices:
        temp = indices[keys]
        #t_mm_count[k]  = temp
        t_mm[k] = np.array([[key[0], key[1], temp] for key in keys.split(":")], dtype=np.int32)
        k += 1
    return t_mm, None  # t_mm_count


def exp2index_mapping(exponent, degree=2):  # (2,3,0,0) ==> (0,0,1,1,1)
    var_indices = []
    i = 1
    for e in exponent:
        var_indices.extend([str(i)]*e)   
        i += 1
    var_indices.extend([str(-1)] * (2*int(degree)-len(var_indices)))
    return np.array(var_indices, dtype=np.str)



