#!/bin/bash

config_path="yaml/forgetting_config.yaml"
# Function to run the training script
run_training() {
    local learning_rate_task1=$1
    local learning_rate_task2=$2
    echo "Running on platform: ${PLATFORM}"

    # Run the training script
    python validate_forgetting.py \
        --config ${config_path} \
        --learning_rate_task1 $learning_rate_task1 \
        --learning_rate_task2 $learning_rate_task2 
}

learning_rates_task1=(1e-3) # (1e-4 5e-4 9e-4 1e-3 3e-3 5e-3 7e-3)
learning_rates_task2=(2e-3) #  7e-3 5e-3 3e-3 1e-3)
# Loop over density values
for lr1 in "${learning_rates_task1[@]}"; do
    for lr2 in "${learning_rates_task2[@]}"; do
        run_training $lr1 $lr2
    done
done


echo "All training runs completed."