import examples.development as development
from examples.development.main import ExperimentRunner
import sys
import os
from copy import deepcopy
from softlearning.replay_pools.utils import get_replay_pool_from_variant
from softlearning.environments.utils import get_environment_from_params
import mopo.off_policy.loader as loader

def main(argv=None):
    example_args = development.get_parser().parse_args(argv)
    variant_spec = development.get_variant_spec(example_args)
    trainable_class = development.get_trainable_class(example_args)
    variant_spec['run_params']['seed'] = 0
    variant_spec['environment_params']['evaluation'] = deepcopy(variant_spec['environment_params']['training'])
    variant_spec['replay_pool_params']['kwargs']['max_size'] = 1000000
    environment_params = variant_spec['environment_params']
    training_environment = get_environment_from_params(environment_params['training'])
    pool = get_replay_pool_from_variant(variant_spec, training_environment)
    pool_load_path = variant_spec['algorithm_params']['kwargs']['pool_load_path']
    pool_load_max_size = variant_spec['algorithm_params']['kwargs']['pool_load_max_size']
    log_dir = os.getcwd()
    loader.restore_pool(pool, pool_load_path, pool_load_max_size, save_path=log_dir)

if __name__ == '__main__':
    main(argv=sys.argv[1:])
