import argparse

def parser_main():
    parser = argparse.ArgumentParser(description='Wasserstein Multi-modal')
    parser.add_argument('--scenario', type=str, default="HalfCheetah-v2", help="environment")
    parser.add_argument('--num_episodes', type=int, default=10000, help="number of episodes for training")
    parser.add_argument('--max_episode_len', type=int, default=1000, help="maximum episode length")
    parser.add_argument('--hidden_dim', type=int, default=256, help="network hidden size")
    parser.add_argument('--log_interval', type=int, default=10, help="calculate avg reward every log_interval episodes")
    parser.add_argument('--updates_per_step', type=int, default=1, help='model updates per simulator step (default: 1)')
    parser.add_argument('--start_steps', type=int, default=10000, help='Steps sampling random actions (default: 10000)')
    parser.add_argument('--target_update_interval', type=int, default=1, help='Value target update per no. of updates per step (default: 1)')
    parser.add_argument('--seed', type=int, default=123, help="random seed for env")
    parser.add_argument('--buffer_limit', type=int, default=100000, help="an imagined limit for replay buffer")
    parser.add_argument('--cuda', action='store_false', help='run on GPU (default: True)')
    parser.add_argument('--policy', type=str, default="Gaussian", help="policy type for backend")
    parser.add_argument('--num_modes', type=int, default=1, help="number of modes that need to learn")
    parser.add_argument('--r_scale', type=float, default=1.0, help="scale factor for true reward")
    parser.add_argument('--sr_scale', type=float, default=0.0, help="scale factor for pseudo reward")
    parser.add_argument('--algo', type=str, default='sac', help="training algorithm for agent learning")
    parser.add_argument('--sr_algo', type=str, default='diayn', help="algorithm for pseudo reward computing")
    parser.add_argument('--schedule', type=str, default='random', help="learning schedule for policy modes")
    parser.add_argument('--run', type=int, default=100, help="index of individual runs")
    return parser