SUMMEVAL_COHERENCE_TASK_DESCRIPTION = '''\
You will be provided with a summary written for a news article.
Your task is to rate the summary based on its coherence.

Please ensure you read and understand these instructions carefully. Keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:
Coherence (1-5):
- 5: The summary is well-structured and organized, presenting information in a logical and seamless flow.
- 4: The summary is mostly coherent, with minor lapses in organization or flow.
- 3: The summary has noticeable organizational issues or lacks a smooth flow but is somewhat understandable.
- 2: The summary is poorly structured, with significant difficulties in following its logic or flow.
- 1: The summary is highly disjointed and lacks any meaningful structure or coherence.
Use these criteria to assign a coherence score between 1 and 5 based on how well the summary organizes and presents information in a clear and logical manner.\
'''


SUMMEVAL_RELEVANCE_TASK_DESCRIPTION = '''\
You will be provided with a summary written for a news article.
Your task is to rate the summary based on its relevance.

Please ensure you read and understand these instructions carefully. Keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:
Relevance (1-5):
- 5: The summary includes all the important information from the source document with no redundancies or irrelevant details.
- 4: The summary is mostly relevant, with only minor omissions or slight redundancies.
- 3: The summary includes some important information but misses key points or has noticeable redundancies.
- 2: The summary contains limited relevant information, with significant omissions or excessive irrelevant content.
- 1: The summary is largely irrelevant, failing to capture the main points of the source document.
Use these criteria to assign a relevance score between 1 and 5 based on how well the summary captures the important content from the source without including excess or redundant information.\
'''


SUMMEVAL_CONSISTENCY_TASK_DESCRIPTION = '''\
You will be provided with a news article and a summary written for this article.
Your task is to rate the summary based on its consistency.

Please ensure you read and understand these instructions carefully. Keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:
Consistency (1-5):
- 5: The summary is fully factually accurate and all its statements are directly supported by the source document.
- 4: The summary is mostly factually accurate, with only minor errors or omissions.
- 3: The summary contains noticeable factual errors or unsupported statements but retains some alignment with the source document.
- 2: The summary has significant factual inaccuracies or includes multiple unsupported claims.
- 1: The summary is largely inconsistent with the source, containing numerous factual inaccuracies or fabricated details.
Use these criteria to assign a consistency score between 1 and 5 based on how well the summary aligns factually with the source article.\
'''



SUMMEVAL_FLUENCY_TASK_DESCRIPTION = '''\
You will be provided with a summary written for a news article.
Your task is to rate the summary based on its fluency.

Please ensure you read and understand these instructions carefully. Keep this document open while reviewing, and refer to it as needed.

Evaluation Criteria:
Fluency (1-5):
- 5: The summary is clear and easy to read, with good grammar, spelling, and sentence structure.
- 4: The summary is generally clear and fluent, with a few minor errors that don't interfere with understanding.
- 3: The summary has some noticeable issues that might make it a little harder to read but still understandable overall.
- 2: The summary has more noticeable problems that might make it challenging to follow in places.
- 1: The summary has significant errors that make it difficult to read or understand in many parts.
Use these criteria to assign a fluency score between 1 and 5 based on the quality of grammar, word choice, and sentence structure.
Important: When evaluating fluency, ignore punctuation and capitalization. Focus only on how natural and easy the language feels regardless of formatting.\
'''


GSM8K_TASK_DESCRIPTIONS = [
    "You are a math tutor who helps students of all levels understand and solve mathematical problems.\nRead the last question carefully and think step by step before answering, the final answer must be only a number.",
    "Read the last question carefully and think step by step before answering, the final answer must be only a number. You are a math tutor who helps students of all levels understand and solve mathematical problems.",
    "Mathematical problem-solving task:\n- Given: A mathematical question or problem\n- Required: A numerical answer only\n- Role: You are a math tutor assisting students of all levels\n- Process: Think step by step to solve the problem\nNote: Read the question carefully before beginning your analysis."
]

EAE_TASK_DESCRIPTION = '''\
You are an argument extractor designed to identify arguments related to specific roles in an event within a sentence.
Your task is to extract all arguments corresponding to the given roles of interest, ensuring they match the semantic role of the provided event trigger. Extract the exact word(s) from the sentence, including pronouns if applicable. If a role has no corresponding argument, assign null as its value.\
'''

TASK_DESCRIPTIONS = {
    "gsm8k": GSM8K_TASK_DESCRIPTIONS,
    "summeval_coherence": [SUMMEVAL_COHERENCE_TASK_DESCRIPTION],
    "summeval_relevance": [SUMMEVAL_RELEVANCE_TASK_DESCRIPTION],
    "summeval_consistency": [SUMMEVAL_CONSISTENCY_TASK_DESCRIPTION],
    "summeval_fluency": [SUMMEVAL_FLUENCY_TASK_DESCRIPTION],
    "eae": [EAE_TASK_DESCRIPTION],
}

FORMAT_DESCRIPTIONS = {
    "gsm8k": {
        "nl": [
            "Provide your output in the following text format:\nAnswer: <reasoning first>. The final answer is <answer>",
            "Provide your output in the following text format:\nStep by step reasoning: ...\nAnswer: The final answer is ...",
            "Provide your output in the following text format:\nReasoning: <think step by step>. Answer: The final answer is <answer>",
        ],
        "json": ["Provide your output in the following valid JSON format:\n{\"reason\": \"<step by step reasoning>\",\"answer\": \"<final answer>\"}"],
    },
    "summeval": {
        "nl": ["Provide your output in the following text format: <analysis of the summary>. Rating: <a number between 1 and 5>"], 
        "json": ["Provide your output in the following valid JSON format:\n{\"analysis\": \"<analysis of the summary>\",\"rating\": <a number between 1 and 5>}"],
    },
    "eae":{
        "nl": ["Provide your output in the following text format:\nThe <role_1> is: <extracted argument>\nThe <role_2> is: <extracted argument>\n...\nThe <role_n> is: <extracted argument>"],
        "json": ["Provide your output in the following valid JSON format:\n{\"<role>\": \"<extracted argument>\" for role in roles of interest}"]
    }
}
