import os

import setuptools
from torch.utils import cpp_extension


# CUTLASS_PATH = os.path.join('.', 'cutlass')

setuptools.setup(
    name='quartet',
    version='0.0.1',
    description='Quartet',
    install_requires=['torch'],
    packages=setuptools.find_packages(exclude=['docs', 'examples', 'tests']),
    ext_modules=[cpp_extension.CUDAExtension(
        'quartet_c',
        [
            'quartet/pybind.cpp',
            'quartet/cvt.cpp',
            'quartet/cvt_kernel.cu',
        ],
        extra_compile_args={
            'cxx': [
                '-O3',
            ],
            'nvcc': [
                '-O3',
                '-gencode', 'arch=compute_120a,code=sm_120a',
            ]
        }
    )],
    # include_dirs=[
    #     os.path.join(CUTLASS_PATH, 'include'),
    #     os.path.join(CUTLASS_PATH, 'tools', 'util', 'include'),
    #     os.path.join('.', 'include'),
    # ],
    cmdclass={'build_ext': cpp_extension.BuildExtension},
)
