# Agent-to-Agent Convergence Dynamics Experiments

This repository contains experiments for multi-agent chain-of-thought interactions with theoretical analysis.

## Main Experiments

### 1. Model Training
```bash
python train.py --lr 0.005 --epochs 100 --d 10 --T 20
```
**Purpose**: Train LSA agents to predict gradients
- `--lr`: Learning rate for model training
- `--epochs`: Number of training epochs
- `--d`: Problem dimension
- `--T`: Number of training samples per dataset

### 2. Agent-to-Agent Analysis
```bash
python agent_to_agent_analysis.py --model_path <path_to_model> --n_samples 1000
```
**Purpose**: Generate figures with theoretical bounds from corollary
- Creates `objective_alignment_study.png` with  eigenvalue-based bounds
- Generates convergence examples (aligned, orthogonal, opposite)

**Key Options**:
- `--convergence_only`: Generate only convergence plots (faster)
- `--sampling_method`: Choose "targeted" or "random" angle sampling

### 3. Adversarial Attacks
```bash
python adversarial_attack.py --agent_type model --model_path <path_to_model> --num_trials 100
```
**Purpose**: Test adversarial robustness of multi-agent systems
- `--agent_type`: Use "model" (trained) or "openai" (GPT-based) agents


## Output Files

- **Plots**: Saved in `png/` and `pdf/` subdirectories
- **Data**: `experimental_results.json` contains raw experimental data with exact eigenvalue parameters
- **Models**: Saved in `experiments/` directory with timestamp

