import torch
import numpy as np
import random


def set_randomSeed(seed=1234):
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    torch.manual_seed(seed)
    np.random.seed(seed)
    random.seed(seed)


def test():
    print("=== test ===")
    set_randomSeed()
    print(np.random.randn(1))
    print(torch.randn(1, device="cpu"))
    # print(torch.randn(1, device="cuda"))


if __name__ == '__main__':
    for _ in range(3):
        test()
