#!/bin/bash
# Usage:
# bash run_all.sh                    # Run GAT model by default, iterate through all datasets
# bash run_all.sh gcn               # Run GCN model, iterate through all datasets
# bash run_all.sh gat /path/to/dataset  # Run GAT model, specify dataset path
# bash run_all.sh gcn /path/to/dataset  # Run GCN model, specify dataset path

ROOT_DIR="yourpath/scUniGP/Data_processing/Dataspilt"
# Select model type: gat or gcn
MODEL_TYPE=${1:-gat}  # Default gat
SPECIFIC_PATH=${2:-""}  # Optional specific path

if [ "$MODEL_TYPE" = "gat" ]; then
    MAIN_PY="main_gat.py"
elif [ "$MODEL_TYPE" = "gcn" ]; then
    MAIN_PY="main_gcn.py"
else
    echo "Model type parameter error, must be gat or gcn"
    echo "Usage:"
    echo "  bash run_all.sh                    # Run GAT model by default"
    echo "  bash run_all.sh gcn               # Run GCN model"
    echo "  bash run_all.sh gat /path/to/dataset  # Run GAT model, specify dataset"
    echo "  bash run_all.sh gcn /path/to/dataset  # Run GCN model, specify dataset"
    exit 1
fi

echo "Will run model: $MAIN_PY"

# If specific path is specified, only run that path
if [ -n "$SPECIFIC_PATH" ]; then
    if [ -d "$SPECIFIC_PATH" ]; then
        echo "Running with base_path: $SPECIFIC_PATH"
        CUDA_VISIBLE_DEVICES=3 python $MAIN_PY --base_path="$SPECIFIC_PATH"
    else
        echo "Error: Specified path does not exist: $SPECIFIC_PATH"
        exit 1
    fi
else
    # Iterate through all datasets
    for TYPE in Lofgof Non-Specific Specific STRING; do
        TYPE_PATH="$ROOT_DIR/$TYPE"
        if [ ! -d "$TYPE_PATH" ]; then
            echo "Skipping non-existent directory: $TYPE_PATH"
            continue
        fi
        for DATASET in "$TYPE_PATH"/*; do
            [ -d "$DATASET" ] || continue
            for TFSET in "$DATASET"/TFs_500 "$DATASET"/TFs_1000; do
                if [ -d "$TFSET" ]; then
                    echo "Running with base_path: $TFSET"
                    CUDA_VISIBLE_DEVICES=3 python $MAIN_PY --base_path="$TFSET"
                fi
            done
        done
    done
fi