#!/bin/bash
# Usage:
# bash run.sh                                    # Run with default parameters
# bash run.sh /path/to/dataset                  # Specify dataset path with default parameters
# bash run.sh /path/to/dataset --batch_size 256 # Specify dataset path and custom parameters

# Default dataset path
DEFAULT_DATA_DIR="yourpath/scUniGP/Data_processing/Dataspilt/Specific/mESC/TFs_500"

# Check if first argument is dataset path
if [ $# -eq 0 ]; then
    # No arguments, use default path
    DATA_DIR="$DEFAULT_DATA_DIR"
    PYTHON_ARGS=""
elif [ -d "$1" ]; then
    # First argument is directory, use as dataset path
    DATA_DIR="$1"
    shift  # Remove first argument, rest as Python arguments
    PYTHON_ARGS="$@"
else
    # First argument is not directory, might be Python arguments
    DATA_DIR="$DEFAULT_DATA_DIR"
    PYTHON_ARGS="$@"
fi

# Check if dataset path exists
if [ ! -d "$DATA_DIR" ]; then
    echo "Error: Dataset path does not exist: $DATA_DIR"
    echo "Usage:"
    echo "  bash run.sh                                    # Use default parameters"
    echo "  bash run.sh /path/to/dataset                  # Specify dataset path"
    echo "  bash run.sh /path/to/dataset --batch_size 256 # Specify path and parameters"
    exit 1
fi

echo "Dataset path: $DATA_DIR"
echo "Python arguments: $PYTHON_ARGS"

# Run Python script
python demo.py --data_dir "$DATA_DIR" $PYTHON_ARGS 