import matplotlib.pyplot as plt
import numpy as np
RESULTS_DIR = "/yourfolderhere/final_figure_generation"
# plt.rcParams['font.family'] = 'DejaVu Sans'
plt.rcParams['font.family'] = 'serif'
plt.rcParams['font.size'] = 12
plt.rcParams['ytick.labelsize'] = 12


colors = ["#5753A3", "#89C5EC", "#E37B3A", "#FAAF6F", "#EFCD76"] # ours guidance, ours sampling, goal conditioning, felix, baseline 

fig, ax = plt.subplots() # figsize=(8, 5)) #, gridspec_kw={'width_ratios': [4/7, 3/7]})

# Data
# for cup decision 
fig.set_size_inches(6, 2, forward=True)
categories = np.arange(3)  # Three bar pairs
bar_width = 0.3
bar_gap = 0.05
red_values = [0.55, 0.75, 0.3]
grey_values = [0.45, 0.25, 0.7]
# red_labels = ["11/20", "15/20", "6/20"]
# grey_labels = ["9/20", "5/20", "14/20"]
red_labels = ["55%", "75%", "30%"]
grey_labels = ["45%", "25%", "70%"]
final_name_suffix = "early_decision"

# for hidden cup 
# fig.set_size_inches(4, 2, forward=True)
# categories = np.arange(2)  # Three bar pairs
# bar_width = 0.3
# bar_gap = 0.05
# red_values = [0.25, 0.8]
# grey_values = [0.75, 0.2]
# # red_labels = ["5/20", "16/20"]
# # grey_labels = ["15/20","4/20"]
# red_labels = ["25%", "80%"]
# grey_labels = ["75%","20%"]
# final_name_suffix = "late_decision"


# for mouse cup
# fig.set_size_inches(4, 2, forward=True)
# categories = np.arange(2)  # Three bar pairs
# bar_width = 0.3
# bar_gap = 0.05
# red_values = [0.85, 0.7]
# grey_values = [0.15, 0.3]
# # red_labels = ["17/20", "14/20"]
# # grey_labels = ["3/20","6/20"]
# red_labels = ["85%", "70%"]
# grey_labels = ["15%","30%"]
# final_name_suffix = "mouse_cup"


# Heights for each bar in the pair


# Bar positions
red_positions = categories + bar_width / 2 + bar_gap / 2
grey_positions = categories - bar_width / 2 - bar_gap / 2 

padding = 3
label_fontsize = 10
# Plotting
red_bar = ax.bar(red_positions, red_values, width=bar_width, label='Set 1', color="#8D191B")
# grey_bar = ax.bar(grey_positions, grey_values, width=bar_width, label='Set 2', color="#A49F99")
grey_bar = ax.bar(grey_positions, grey_values, width=bar_width, label='Set 2', color="#262724")
ax.bar_label(grey_bar, labels = grey_labels, padding = 3, fontname = "serif", fontsize = label_fontsize)
ax.bar_label(red_bar, labels = red_labels, padding = 3, fontname = "serif", fontsize = label_fontsize)
# ax.bar_label(grey_bar, labels = [1, 2, 3], paddinng=padding, fontsize=label_fontsize, fontname="serif")


# baseline_bar = ax2.bar(x_right + 1.5 * width, list(ctrl_means.values()) + [mean(ctrl_means.values())], width,  capsize=capsize, error_kw=error_kw,
#                        yerr = list(ctrl_vars.values()) + [combined_std(ctrl_vars.values(), ctrl_means.values())], label="Base Policy", color = colors[4])
# ax2.bar_label(baseline_bar, labels = [f"{val:.2f}" for val in list(ctrl_means.values()) + [mean(ctrl_means.values())]], padding=padding, fontsize=label_fontsize, fontname="serif")


# ax2.bar_label(baseline_bar, labels = [f"{val:.2f}" for val in list(ctrl_means.values()) + [mean(ctrl_means.values())]], padding=padding, fontsize=label_fontsize, fontname="serif")

# Hide x-axis labels
# plt.xticks([], [])

ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.spines['left'].set_visible(False)
# ax2.spines['bottom'].set_visible(False)

# ax2.spines['bottom'].set_position(('outward', 5))


# yticks2 = ax2.get_yticks()
# ax2.set_yticks(yticks2[1:])
ax.set_xticks([])
plt.gca().axes.get_yaxis().set_visible(False)
plt.tight_layout()
plt.savefig(f"{RESULTS_DIR}/RealRobot_{final_name_suffix}.pdf", transparent=True)
plt.close()

