#!/bin/bash

# FORMATTING 
# -[behavior name]_[modifier]_[seed]
# -modifier includes none (ours), rejection, and goal 

# this bash script should handle the full experiment upon a single run 

cleanup() {
    echo "Terminating all background processes..."
    pkill -P $$  # Kill all child processes of this script
    exit 1
}

# Trap Ctrl+C (SIGINT) and call cleanup function
trap cleanup SIGINT 

num_trials=50

dynamics_model=/yourfolderhere/results/classifiers/CALVINABCD_blockseg_newmodel_8head_6_depth_NOISED_wproprio_padsame/3000.pth


# TRAINING CODE 
datasets=(
    # "/yourfolderhere/dataset/CalvinDD_switch_1percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch_3percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch_5percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch_10percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch_20percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch40percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch60percent/data.hdf5"
    # "/yourfolderhere/dataset/CalvinDD_switch80percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_1_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_5_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_10_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_20_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_40_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_60_percent/data.hdf5"
    "/yourfolderhere/dataset/CalvinDD_door_left_80_percent/data.hdf5"
)

splits=(1 3 5 10 20 40 60 80)

count=0
gpudevice=4
exp_root=/yourfolderhere/FINAL_EXPERIMENTS/Multi_Neg/
base_folder=/yourfolderhere/results
count=0
for dataset in "${datasets[@]}"; do
    python split_train_val.py --dataset $dataset --ratio 0.03
    output_name=calvin_door_left_gc_${splits[$count]}_percent
    CUDA_VISIBLE_DEVICES=4 python train.py --config configs/diffusion_policy_image_calvin_ddim.json --dataset $dataset --output $base_folder  --name $output_name &

    # CUDA_VISIBLE_DEVICES=5 python train.py --config configs/diffusion_policy_image_calvin_ddim_gc.json --dataset $dataset  --output $base_folder \
    #     --name $output_name \
    #     --goal_dir /yourfolderhere/dataset/Calvin_Goals/switch_on &

    echo $output_name
    ((count++))
    echo $count 
    if [ $count = 4 ]; then 
        wait 
    fi 
done 
wait 

exit 


exp_root=/yourfolderhere/FINAL_EXPERIMENTS/Deprivation/
splits=(1 3 5 10 20 40 60 80)
gpudevice=5

base_policies=(
   "/yourfolderhere/results/calvin_switch_1_percent/20250409210340/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_3_percent/20250409210346/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_5_percent/20250409210417/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_10_percent/20250409211037/models/model_epoch_300.pth"
    "/yourfolderhere/results/calvin_switch_20_percent/20250410233442/models/model_epoch_300.pth"
    "/yourfolderhere/results/calvin_switch_40_percent/20250410233535/models/model_epoch_300.pth"
    "/yourfolderhere/results/calvin_switch_60_percent/20250410233950/models/model_epoch_300.pth"
    "/yourfolderhere/results/calvin_switch_80_percent/20250410235418/models/model_epoch_300.pth"
)

gc_policies=(
   "/yourfolderhere/results/calvin_switch_gc_1_percent/20250416010753/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_3_percent/20250416010753/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_5_percent/20250416010753/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_10_percent/20250416010753/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_20_percent/20250416154054/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_40_percent/20250416154054/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_60_percent/20250416154054/models/model_epoch_300.pth"
   "/yourfolderhere/results/calvin_switch_gc_80_percent/20250416154054/models/model_epoch_300.pth"
)

# # ############ FOR THE ARTICULATED OBJECTS 

# count=0
# for ckpt_dir in "${base_policies[@]}"; do
#     for i in $(seq 0 5); do
#         echo "On checkpoint $ckpt_dir"
#         run_name=switch_on_${splits[$count]}_$i
#         exp_setup_config=/yourfolderhere/calvin_exp_configs/switch_on.json
#         output_folder=$exp_root$run_name
#         CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
#             --dataset_path $exp_root$run_name/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
#             --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
#             --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.5 --ss 4 --alpha 30 &
#         echo $run_name 
#     done
#     wait
#      ((count++))
# done

# count=0
# for ckpt_dir in "${base_policies[@]}"; do
#     for i in $(seq 0 5); do  
#         echo "On checkpoint $ckpt_dir"

#         run_name=switch_on_control_${splits[$count]}_$i
#         exp_setup_config=/yourfolderhere/calvin_exp_configs/switch_on.json
#         output_folder=$exp_root$run_name
#         CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
#             --dataset_path $exp_root$run_name/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
#             --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
#             --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 &
#         echo $run_name 
#     done
#     wait
#     ((count++))
# done

# count=0
# for ckpt_dir in "${base_policies[@]}"; do
#     for i in $(seq 0 5); do 
#         echo "On checkpoint $ckpt_dir"
#         run_name=switch_on_planner_${splits[$count]}_$i
#         exp_setup_config=/yourfolderhere/calvin_exp_configs/switch_on.json
#         output_folder=$exp_root$run_name
#         CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
#             --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts $num_trials \
#             --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
#             --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
#         echo $run_name 
#     done
#     wait
#     ((count++))
# done 

# # exit #TODO: this is not correct 
# count=0
# for ckpt_dir in "${gc_policies[@]}"; do
#     for i in $(seq 0 5); do 
#         echo "On checkpoint $ckpt_dir"
#         run_name=switch_on_gc_${splits[$count]}_$i
#         exp_setup_config=/yourfolderhere/calvin_exp_configs/switch_on.json
#         output_folder=$exp_root$run_name
#         goal_dir=/yourfolderhere/dataset/Calvin_Goals/switch_on
#         CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
#             --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
#             --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
#             --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 &
#         echo $run_name 
#     done 
#     wait 
#     ((count++))

# done
# wait
