#!/bin/bash

# FORMATTING 
# -[behavior name]_[modifier]_[seed]
# -modifier includes none (ours), rejection, and goal 

# this bash script should handle the full experiment upon a single run 

cleanup() {
    echo "Terminating all background processes..."
    pkill -P $$  # Kill all child processes of this script
    exit 1
}

# Trap Ctrl+C (SIGINT) and call cleanup function
trap cleanup SIGINT 

num_trials=50

dynamics_model=/yourfolderhere/results/classifiers/CALVINABCD_blockseg_newmodel_8head_6_depth_NOISED_wproprio_padsame/3000.pth
base_policies=(
    "/yourfolderhere/results/CalvinTrain_block_ddim_1/20250328091252/models/model_epoch_300.pth"
    "/yourfolderhere/results/CalvinTrain_block_ddim_2/20250328222956/models/model_epoch_300.pth"
    "/yourfolderhere/results/CalvinTrain_block_ddim_3/20250330072924/models/model_epoch_300.pth"
    "/yourfolderhere/results/CalvinTrain_block_ddim_4/20250331072129/models/model_epoch_300.pth"
    "/yourfolderhere/results/CalvinTrain_block_ddim_5/20250330073012/models/model_epoch_300.pth"
    "/yourfolderhere/results/CalvinTrain_block_ddim_6/20250331072422/models/model_epoch_300.pth"
)
goal_conditioning_policies=(
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed1/20250407162840/models/model_epoch_380.pth"
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed2/20250407162840/models/model_epoch_380.pth"
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed3/20250407162840/models/model_epoch_380.pth"
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed4/20250407162840/models/model_epoch_380.pth"
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed5/20250407162840/models/model_epoch_380.pth"
    "/yourfolderhere/results/CalvinALLDataTrain_ddim_goalconditioned_blocks_seed6/20250407162840/models/model_epoch_380.pth"
)
count=0
gpudevice=5
exp_root=/yourfolderhere/FINAL_EXPERIMENTS/PartialGoals/


############ FOR THE ARTICULATED OBJECTS 
# for ckpt_dir in "${base_policies[@]}"; do
#     echo "On checkpoint $ckpt_dir"

            # run_name=switch_on_$count
            # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_on.json
            # output_folder=$exp_root$run_name
            # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
            #     --dataset_path $exp_root$run_name/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
            #     --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
            #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.5 --ss 4 --alpha 30 &
            # echo $run_name 

            # run_name=switch_off_$count
            # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_off.json
            # output_folder=$exp_root$run_name
            # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
            #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
            #     --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
            #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.5 --ss 4 --alpha 30 &
            # echo $run_name 

    # run_name=drawer_open_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_open.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.5 --ss 4 --alpha 40 & 
    # echo $run_name 

    # run_name=drawer_close_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_close.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.5 --ss 4 --alpha 40 & 
    # echo $run_name 

        # run_name=button_on_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_on.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.6 --ss 4 --alpha 20 & 
        # echo $run_name 

        # run_name=button_off_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_off.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.6 --ss 4 --alpha 20 & 
        # echo $run_name 

    # run_name=door_left_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_left.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.2 --ss 4 --alpha 40 & 
    # echo $run_name 

    # used to be scale 1.8 and alpha 20 but we were a bit too aggressive I think 
    
    # run_name=door_right_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_right.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder  --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --scale 1.2 --ss 4 --alpha 15 & 
    # echo $run_name 

    # wait # wait this batch to stop 

#     ((count++))
# done
# wait

######## ARTICULATED SAMPLING 
count=0
for ckpt_dir in "${base_policies[@]}"; do
    echo "On checkpoint $ckpt_dir"
        # run_name=switch_on_planner_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_on.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
        # echo $run_name 

        # run_name=switch_off_planner_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_off.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
        # echo $run_name`

        # run_name=button_off_planner_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_off.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
        # echo $run_name 

        # run_name=button_on_planner_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_on.json
        # output_folder=$exp_root$run_name
        # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
        # echo $run_name 

    run_name=door_left_planner_$count
    exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_left.json
    output_folder=$exp_root$run_name
    CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 4 &
    echo $run_name 

    run_name=door_right_planner_$count
    exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_right.json
    output_folder=$exp_root$run_name
    CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
        --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
        --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
        --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 4 &
    echo $run_name 

    # run_name=drawer_open_planner_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_open.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
    # echo $run_name 

    # run_name=drawer_close_planner_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_close.json
    # output_folder=$exp_root$run_name
    # CUDA_VISIBLE_DEVICES=$gpudevice python rejection_sampling_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 200 --n_rollouts 50 \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 5  \
    #     --exp_setup_config $exp_setup_config --guidance $dynamics_model --camera_names third_person --num_samples 5 &
    # echo $run_name 

    wait # make sure that you don't set off too many at once 
    ((count++))

done 
wait 

########### GOAL CONDITIONING
# count=0
# for ckpt_dir in "${goal_conditioning_policies[@]}"; do
#     echo "On checkpoint $ckpt_dir"

        # run_name=switch_on_gc_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_on.json
        # output_folder=$exp_root$run_name
        # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_switch_on
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $exp_root$run_name/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 &
        # echo $run_name 

        # run_name=switch_off_gc_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_switch_off.json
        # output_folder=$exp_root$run_name
        # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_switch_off
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $exp_root/$run_name --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 &
        # echo $run_name 

    # run_name=drawer_open_gc_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_open.json
    # output_folder=$exp_root$run_name
    # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_drawer_open
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 40 & 
    # echo $run_name 

    # run_name=drawer_close_gc_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_drawer_close.json
    # output_folder=$exp_root$run_name
    # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_drawer_close
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 40 & 
    # echo $run_name 

        # run_name=button_on_gc_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_on.json
        # output_folder=$exp_root$run_name
        # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_button_on
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 & 
        # echo $run_name 

        # run_name=button_off_gc_$count
        # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_button_off.json
        # output_folder=$exp_root$run_name
        # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_button_off
        # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
        #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
        #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
        #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 & 
        # echo $run_name 

    # run_name=door_left_gc_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_left.json
    # output_folder=$exp_root$run_name
    # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_door_left
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 & 
    # echo $run_name 

    # run_name=door_right_gc_$count
    # exp_setup_config=/yourfolderhere/calvin_exp_configs/ood_door_right.json
    # output_folder=$exp_root$run_name
    # goal_dir=/yourfolderhere/dataset/Calvin_Goals/ood_door_right
    # CUDA_VISIBLE_DEVICES=$gpudevice python classifier_guidance_dino.py  --video_path $output_folder/$run_name.mp4 \
    #     --dataset_path $output_folder/$run_name.hdf5 --dataset_obs --json_path $output_folder/$run_name.json --horizon 400 --n_rollouts $num_trials \
    #     --agent $ckpt_dir --output_folder $output_folder  --video_skip 2  \
    #     --exp_setup_config $exp_setup_config --goal_dir $goal_dir --guidance $dynamics_model --camera_names third_person --scale 0 --ss 1 --alpha 30 & 
    # echo $run_name 

    # wait # wait this batch to stop 

#     ((count++))
# done
# wait


echo "All configurations processed successfully."