# Rough Supplemental Code Release 
This folder contains an exported version of the repository we used to develop DynaGuide. In the near future, we will release a version of the codebase that can be very easily used by researchers. 
# Installing the Environment for CALVIN Experiments
1. Install the conda environment `calvin_venv` using the provided `environment.yml`
1. Install [Robomimic](https://robomimic.github.io/) at [this commit](https://github.com/ARISE-Initiative/robomimic/tree/ff36c1c16e034d9e68aa8ae16a57e53ef2b74085). 
1. Replace the four folders in the installed `robomimic/robomimic/` with the folders provided in `RobomimicModification` in this repository
1. Install the [Calvin](https://github.com/mees/calvin) benchmark
1. Replace the folder `calvin/calvin_env/calvin_env/scene` with the folder provided in `CalvinModification` in this repository 

# Getting the data
For the calvin data, we download the ABCD and the D split from the [project website](https://github.com/mees/calvin). Use the `scripts/calvin_to_labeled_hdf5.py` to segment the data into trajectories and save to `.hdf5` format used in this project. 

To get trajectories split by target behavior, use `scripts/split_behavioral_validation_datasets_calvin.py` to split the generated `hdf5` file into `hdf5` files for each behavior. These files represent the guidance conditions. Use scripts like `hdf5_filter.py`, `hdf5_combiner.py` to merge and separate these files for multi-objective guidance conditions. 

To get exact copies of the guidance conditions for the ArticulatedParts experiment, we make them available at [this link](https://drive.google.com/drive/folders/1ENpR1m5HmLKIOVNrozh20_FxYcb07wWN?usp=sharing)

# Running Experiments
## Files of Interest
- `train.py`: code used to train the base policy 
- `train_end_state_embedder_dino.py`: code used to train the dynamics model
- `test_end_state_embedder_dino.py`: a testing suite to diagnose the dynamics model
- `rejection_sampling_dino.py`: code used to conduct the sampling baseline on the CALVIN environment
- `classifier_guidance_dino.py`: code used to run DynaGuide on the CALVIN environment 
- `embedder_models.py`: code for the dynamics model 
## Running the code
The scripts used to generate the experiment result are located in `experiments/paper_exps/`, which call the programs above with the appropiate flags. These experiments use configurations found in `calvin_exp_configs/`, which need to be changed to replace the anonymized placholder file paths with paths to data. These configs point to positive and negative guidance conditions represented as `hdf5` files (see: `Getting the Data`). These configs also point to a file with random start poses for the robot, taken from validation trajectories. These files are also included in `calvin_exp_configs/`

The scripts need checkpoints to trained dynamics models and base policies. Training scripts can be found in `experiments/train_base_policy.sh` and `experiments/train_dynamics_model.sh`. An example trained base policy can be found [here](https://drive.google.com/file/d/1l3hRTI4Zig0Nv74kvL7ewQG10xG52LBL/view?usp=sharing) and an example trained dynamics model can be found [here](https://drive.google.com/file/d/19Zv5T_waEgufyrdb7-aOYEfW9Q7Bq8F5/view?usp=sharing)

## Visualizing the Outcomes
The evaluation scripts generate files in a results directory, and these files are read by the scripts in `final_figure_generation/` which take the rollouts and compute statistics and create the graphs seen in the paper. 

# Sample workflow
1. Acquire all the data from the CALVIN benchmark
1. Segment the data to create training and validation `hdf5` files
1. Use the training data to train the base policy and the dynamics model
1. Use the validation data to create guidance conditions 
1. Run DynaGuide / other baselines
1. Use the figure generation script to compute statistics from these runs 

## Minimum working version
If you want to get an experiment working, we suggest using the pretrained base policies + dynamics model and running the ArticulatedParts experiment by downloading the guidance conditions above. This will require no additional training or data processing. 