from peft import LoraConfig


GPT_LORA_CONFIG = LoraConfig(
    r=8,
    lora_alpha=32,
    lora_dropout=0.05,
    target_modules=['c_attn', 'c_proj', 'c_fc'],
    modules_to_save=['param_embed', 'transform', 'wte', 'wpe', 'lm_head'],
    fan_in_fan_out=True
)

PHI_LORA_CONFIG = LoraConfig(
    r=8,
    lora_alpha=32,
    lora_dropout=0.05,
    target_modules=['o_proj', 'qkv_proj', 'gate_up_proj', 'down_proj'],
    modules_to_save=['param_embed', 'transform', 'embed_tokens', 'lm_head'],
)

LLAMA_LORA_CONFIG = LoraConfig(
    r=8,
    lora_alpha=32,
    lora_dropout=0.05,
    target_modules=['q_proj', 'k_proj', 'v_proj', 'o_proj', 'gate_proj', 'up_proj', 'down_proj'],
    modules_to_save=['param_embed', 'transform', 'embed_tokens', 'lm_head'],
)