#!/usr/bin/env bash
export TOGETHER_API_KEY=
export WANDB_API_KEY=
BASE_MODEL="meta-llama/Meta-Llama-3.1-8B-Instruct-Turbo"
MODE="nl"
METHOD="2class_8shot"
DATASET_NAME='folio'
DATASET_RATIO='cotmore'
OUTPUT_DIR="outputs"
N_SAMPLES=7000
N_OUTER_LOOPS=3
N_EPOCHS=4
BATCH_SIZE=32
LEARNING_RATE=5e-6
LORA="--lora" 
LORA_R=16
LORA_ALPHA=32
LORA_DROPOUT=0.0
MAX_TOKENS=2048
TEMPERATURE=0.7
TOP_P=0.9
TOP_K=50
SEED=42

python star_pipeline_together_ai.py \
    --base_model "$BASE_MODEL" \
    --mode "$MODE" \
    --method "$METHOD" \
    --dataset_name "$DATASET_NAME" \
    --output_dir "$OUTPUT_DIR" \
    --n_samples "$N_SAMPLES" \
    --n_outer_loops "$N_OUTER_LOOPS" \
    --n_epochs "$N_EPOCHS" \
    --batch_size "$BATCH_SIZE" \
    --learning_rate "$LEARNING_RATE" \
    $LORA \
    --lora_r "$LORA_R" \
    --lora_alpha "$LORA_ALPHA" \
    --lora_dropout "$LORA_DROPOUT" \
    --max_tokens "$MAX_TOKENS" \
    --temperature "$TEMPERATURE" \
    --top_p "$TOP_P" \
    --top_k "$TOP_K" \
    --seed "$SEED" \
    --dataset_ratio "$DATASET_RATIO"
