import torch

from .dag_denoising_dataset import DAGDenoisingDataset
from .electrical_circuits_denoising_interpolation_dataset import (
    ElectricalCircuitsDenoisingInterpolationDataset,
)
from .inductive_dataset import InductiveDataset
from .longest_cycle_identification_dataset import LongestCycleIdentificationDataset
from .mixed_longest_cycle_identification_dataset import (
    MixedLongestCycleIdentificationDataset,
)
from .random_walk_denoising_dataset import RandomWalkDenoisingDataset
from .tntp_flow_denoising_interpolation_dataset import (
    TNTPFlowDenoisingInterpolationDataset,
)
from .traffic_la_dataset import TrafficLADataset
from .transductive_dataset import TransductiveDataset
from .typed_triangles_orientation_dataset import TypedTrianglesOrientationDataset

torch.serialization.add_safe_globals(
    [
        InductiveDataset,
        TransductiveDataset,
        TrafficLADataset,
        TNTPFlowDenoisingInterpolationDataset,
        ElectricalCircuitsDenoisingInterpolationDataset,
        RandomWalkDenoisingDataset,
        DAGDenoisingDataset,
        LongestCycleIdentificationDataset,
        MixedLongestCycleIdentificationDataset,
        TypedTrianglesOrientationDataset,
    ]
)

__all__ = [
    "InductiveDataset",
    "TransductiveDataset",
    "TrafficLADataset",
    "TNTPFlowDenoisingInterpolationDataset",
    "ElectricalCircuitsDenoisingInterpolationDataset",
    "RandomWalkDenoisingDataset",
    "DAGDenoisingDataset",
    "LongestCycleIdentificationDataset",
    "MixedLongestCycleIdentificationDataset",
    "TypedTrianglesOrientationDataset",
]
