# Installation

Install the code via `pip install -e .`.

# Running the code

You can run the code via `python3 train.py with {setting} {model} [hyperparameter_config] [wandb] [args*]`.

A few options for the `setting` are:
- `traffic_flow_{task}_{city}`
- `electrical_circuits_{task}`
- `random_walk_denoising` (RW Comp)
- `mixed_longest_cycle_identification` (LD Cycles)
- `typed_triangles_orientation` (Tri-Flow)

Cities are: `anaheim`, `barcelona`, `chicago`, `winnipeg`
Tasks are:  `denoising`, `interpolation`, `simulation`

Models are:
- MLP: `mlp`
- LineGraph GNN: `line_graph_gnn`
- HodgeGNN: `equivariant_hodge_gnn`
- Hodge+Inv: `concatenated_hodge_gnn`
- Hodge+Dir: `directed_hodge_gnn`

- EIGN: `mixed_magnetic_edge_gnn_and_fusion`
- EIGN (q=0): `mixed_edge_gnn_and_fusion`
- EIGN, no fusion: `mixed_magnetic_edge_gnn`
- EIGN, no fusion convolution: `magnetic_edge_gnn`

You can set hyperparameters directly (see `magnetic_edge_gnn/configs/default.py`), e.g. via adding an argument to the end of the argument list `model.num_layers=5`, or load the hyperparameter configurations we tuned via setting the hyperparameter config to one of the following:

- `traffic_flow_denoising_best_hyperparameters`
- `traffic_flow_interpolation_best_hyperparameters`
- `traffic_flow_simulation_best_hyperparameters`
- `electrical_circuits_denoising_best_hyperparameters`
- `electrical_circuits_interpolation_best_hyperparameters`
- `electrical_circuits_simulation_best_hyperparameters`
- `random_walk_denoising_best_hyperparameters`
- `mixed_longest_cycle_identification_best_hyperparameters`
- `typed_triangles_orientation_best_hyperparameters`