import os
import pickle
import subprocess
import numpy as np

tuples = []

mnist_commands = []
two_clusters_commands = []
from_kernel_commands = []

for seed in range(3):
    for train_set_size in [500, 1000, 2000, 3000, 4000, 5000, 6000, 8000, 10000]:
        lam = 0.00707
                
        output_dir = f'./mnist_final/seed_{seed}/{train_set_size}'

        first_command = f'python3 distill_dataset.py --dataset_name mnist_zero_one --output_dir ./{output_dir} --train_set_size {train_set_size} --lam {lam} --scale_mode sqrt --lengthscale 13.9 --use_mse --learn_labels --min_size 2 --seed {seed} --init_real --batch_size 2000 --s_factor 1'
                            
        cmd = 'cd ../../ && {}'.format(first_command)

        mnist_commands.append(cmd)
    
    for sigma in np.linspace(0.25, 5.0, 20):
        lam = 1e-5
        output_dir = f'./two_clusters_finalddddddd/seed_{seed}/sigma_{sigma}/'
        

        first_command = f'python3 distill_dataset.py --dataset_name two_clusters --output_dir {output_dir} --train_set_size 10000 --lam {lam} --lengthscale 1.5 --use_mse --learn_labels --sigma {sigma} --init_real --s_factor 1 --seed {seed}'

        cmd = 'cd ../../ && {}'.format(first_command)

        two_clusters_commands.append(cmd)

    for sigma in np.linspace(0.25, 5.0, 20):
        lam = 1e-5
        output_dir = f'./from_kernel_finaldddddd/seed_{seed}/sigma_{sigma}/'
        


        first_command = f'python3 distill_dataset.py --dataset_name from_kernel --output_dir {output_dir} --train_set_size 10000 --lam {lam} --lengthscale 1.5 --use_mse --learn_labels --sigma {sigma} --init_real --s_factor 1 --seed {seed}'

        cmd = 'cd ../../ && {}'.format(first_command)

        from_kernel_commands.append(cmd)


for i, cmd in enumerate(mnist_commands):
    filename = './mnist_{}.pkl'.format(i)
    print(f'running command {i}, {cmd}')

    if(os.path.exists(filename)):
        print("already")
    else:
        pickle.dump({}, open(filename, 'wb'))
        print('makeing')
        subprocess.call(cmd, shell=True)
        filename_done = './mnist_{}_done.pkl'.format(i)
        pickle.dump({}, open(filename_done, 'wb'))


for i, cmd in enumerate(two_clusters_commands):
    filename = './tc_{}.pkl'.format(i)
    print(f'running command {i}, {cmd}')

    if(os.path.exists(filename)):
        print("already")
    else:
        pickle.dump({}, open(filename, 'wb'))
        print('makeing')
        subprocess.call(cmd, shell=True)
        filename_done = './tc_{}_done.pkl'.format(i)
        pickle.dump({}, open(filename_done, 'wb'))


for i, cmd in enumerate(from_kernel_commands):
    filename = './fk_{}.pkl'.format(i)
    print(f'running command {i}, {cmd}')

    if(os.path.exists(filename)):
        print("already")
    else:
        pickle.dump({}, open(filename, 'wb'))
        print('makeing')
        subprocess.call(cmd, shell=True)
        filename_done = './fk_{}_done.pkl'.format(i)
        pickle.dump({}, open(filename_done, 'wb'))

# print(len(commands))
print('done')
