__all__ = ["VGGFace2DatasetSize", "VGGFace2Dataset"]

from pathlib import Path
from typing import Union, Optional, Tuple, List, Dict

import torch
from torch.utils.data import DataLoader

from advfaceutil.datasets.faces.base import RESEARCHERS, FaceDatasetSize, FaceDataset
from advfaceutil.utils import split_data

TRAINING_IMAGE_LIMIT = 240
TESTING_IMAGE_LIMIT = 60


class VGGFace2DatasetSize(FaceDatasetSize):
    """
    Enumerate the names of individuals for each VGGFace2 dataset size.
    """

    SMALL = [
        "n001159",
        "n000172",
        "n001586",
        "n000395",
        "n000419",
        "n000705",
        "n007079",
    ]

    LARGE = [
        "n000172",
        "n000176",
        "n000185",
        "n000225",
        "n000266",
        "n000395",
        "n000419",
        "n000692",
        "n000705",
        "n000737",
        "n000810",
        "n000812",
        "n000835",
        "n000943",
        "n000944",
        "n000956",
        "n001024",
        "n001026",
        "n001145",
        "n001159",
        "n001387",
        "n001540",
        "n001586",
        "n001588",
        "n001592",
        "n001645",
        "n001657",
        "n001700",
        "n001765",
        "n001775",
        "n001917",
        "n002141",
        "n002298",
        "n002462",
        "n002537",
        "n002545",
        "n002644",
        "n002886",
        "n002888",
        "n003021",
        "n003027",
        "n003206",
        "n003303",
        "n003335",
        "n003459",
        "n003485",
        "n003523",
        "n003831",
        "n003838",
        "n003912",
        "n003913",
        "n003998",
        "n004144",
        "n004198",
        "n004216",
        "n004231",
        "n004407",
        "n004408",
        "n004457",
        "n004508",
        "n004535",
        "n004538",
        "n004565",
        "n004589",
        "n004617",
        "n004656",
        "n004737",
        "n004806",
        "n004844",
        "n004936",
        "n005018",
        "n005089",
        "n005191",
        "n005219",
        "n005464",
        "n005493",
        "n006108",
        "n006214",
        "n006359",
        "n006363",
        "n006427",
        "n006481",
        "n006688",
        "n006695",
        "n006776",
        "n007050",
        "n007052",
        "n007079",
        "n007139",
        "n007160",
        "n007229",
        "n007237",
        "n007313",
        "n007331",
        "n007428",
        "n007564",
        "n007620",
    ]

    FINAL = [
        "n004142",
        "n005034",
        "n001479",
        "n004373",
        "n002679",
        "n002950",
        "n006350",
        "n004473",
        "n004794",
        "n005037",
        "n004457",
        "n006688",
        "n002383",
        "n004352",
        "n003521",
        "n001129",
        "n000358",
        "n007047",
        "n006016",
        "n000202",
        "n004365",
        "n006094",
        "n000234",
        "n005395",
        "n005643",
        "n005471",
        "n007129",
        "n005018",
        "n006377",
        "n007106",
        "n003066",
        "n005972",
        "n001960",
        "n002630",
        "n004908",
        "n004220",
        "n000043",
        "n007659",
        "n000309",
        "n002862",
        "n004988",
        "n005518",
        "n000554",
        "n000547",
        "n004616",
        "n004045",
        "n005270",
        "n003969",
        "n004977",
        "n003153",
        "n000661",
        "n002201",
        "n002471",
        "n005089",
        "n007229",
        "n003993",
        "n003979",
        "n007139",
        "n002933",
        "n004161",
        "n003988",
        "n005740",
        "n002792",
        "n007413",
        "n004413",
        "n003475",
        "n002172",
        "n002883",
        "n003287",
        "n003039",
        "n003214",
        "n006771",
        "n000435",
        "n007232",
        "n007402",
        "n007027",
        "n002724",
        "n003586",
        "n001178",
        "n006904",
        "n003923",
        "n004970",
        "n004493",
        "n005180",
        "n007616",
        "n005584",
        "n007258",
        "n004194",
        "n007353",
        "n000383",
        "n000705",
        "n003109",
        "n004806",
        "n003620",
        "n002633",
        "n003895",
        "n002448",
        "n006650",
        "n001200",
        "n007428",
        "n002954",
        "n003180",
        "n006410",
        "n006341",
        "n006917",
        "n003507",
        "n000839",
        "n001765",
        "n001587",
        "n000450",
        "n005446",
        "n007446",
        "n006566",
        "n000823",
        "n000933",
        "n003938",
        "n000633",
        "n005827",
        "n002525",
        "n002298",
        "n004069",
        "n000142",
        "n005080",
        "n003206",
        "n007573",
        "n000865",
        "n001763",
        "n000857",
        "n003899",
        "n002886",
        "n002447",
        "n004144",
        "n007031",
        "n006015",
        "n002944",
        "n007160",
        "n003443",
        "n004013",
        "n004684",
        "n001041",
        "n005662",
        "n003055",
        "n004236",
        "n007420",
        "n004348",
        "n001229",
        "n006220",
        "n003035",
        "n005665",
        "n003820",
        "n003344",
        "n004553",
        "n000568",
        "n003335",
        "n003350",
        "n000228",
        "n005290",
        "n002557",
        "n005292",
        "n002777",
        "n004467",
        "n007696",
        "n006784",
        "n004150",
        "n001349",
        "n001584",
        "n000956",
        "n001024",
        "n002334",
        "n007138",
        "n000316",
        "n000752",
        "n004497",
        "n000271",
        "n006995",
        "n007327",
        "n000732",
        "n004617",
        "n002887",
        "n001700",
        "n002746",
        "n002085",
        "n003120",
        "n000543",
        "n006165",
        "n006343",
        "n002440",
        "n002316",
        "n007052",
        "n006936",
        "n002632",
        "n003306",
        "n003520",
        "n001148",
        "n006157",
        "n004695",
        "n002237",
        "n004913",
        "n003911",
        "n004216",
        "n001826",
        "n005433",
        "n006776",
        "n003905",
        "n004800",
        "n001259",
        "n001227",
        "n005616",
        "n000027",
        "n007661",
        "n005164",
        "n001142",
        "n001837",
        "n006943",
        "n003098",
        "n006982",
        "n000126",
        "n003107",
        "n002138",
        "n003265",
        "n005553",
        "n000911",
        "n006751",
        "n001578",
        "n003370",
        "n003776",
        "n001111",
        "n003030",
        "n003727",
        "n002572",
        "n003136",
        "n003395",
        "n007356",
        "n003162",
        "n003800",
        "n000537",
        "n004904",
        "n003378",
        "n007494",
        "n000541",
        "n007619",
        "n006470",
        "n006427",
        "n001091",
        "n007445",
        "n004831",
        "n007185",
        "n006842",
        "n001917",
        "n003373",
        "n002759",
        "n000645",
        "n003247",
        "n006499",
        "n001509",
        "n004998",
        "n002188",
        "n006895",
        "n005416",
        "n003756",
        "n001492",
        "n006716",
        "n001783",
        "n006831",
        "n003198",
        "n004940",
        "n002310",
        "n007563",
        "n006691",
        "n003363",
        "n004131",
        "n003580",
        "n001594",
        "n001066",
        "n003463",
        "n002486",
        "n003033",
        "n005814",
        "n003815",
        "n005759",
        "n002035",
        "n002021",
        "n004714",
        "n006153",
        "n001645",
        "n000560",
        "n002094",
        "n002982",
        "n007567",
        "n002332",
        "n000090",
        "n007086",
        "n000199",
        "n006682",
        "n003965",
        "n001025",
        "n001586",
        "n001654",
        "n007604",
        "n005585",
        "n002971",
        "n000727",
        "n002419",
        "n006118",
        "n000255",
        "n006141",
        "n003021",
        "n004681",
        "n001601",
        "n004589",
        "n003936",
        "n006899",
        "n003998",
        "n005031",
        "n005908",
        "n003459",
        "n004198",
        "n006695",
        "n007653",
        "n002545",
        "n003924",
        "n002644",
        "n000885",
        "n006782",
        "n006570",
        "n005335",
        "n003324",
        "n006393",
        "n006937",
        "n003174",
        "n000413",
        "n006710",
        "n004935",
        "n006874",
        "n006005",
        "n000643",
        "n005496",
        "n001794",
        "n001553",
        "n007702",
        "n007752",
        "n004543",
        "n005219",
        "n005124",
        "n002710",
        "n001907",
        "n003605",
        "n000223",
        "n007255",
        "n002061",
        "n000217",
        "n005305",
        "n004508",
        "n007102",
        "n003846",
        "n004356",
        "n004968",
        "n006660",
        "n002202",
        "n004038",
        "n000395",
        "n004251",
        "n006126",
        "n006384",
        "n005836",
        "n000692",
        "n006588",
        "n001588",
        "n007075",
        "n000172",
        "n003316",
        "n004737",
        "n002163",
        "n004159",
        "n003429",
        "n006583",
        "n000771",
        "n001677",
        "n004672",
        "n003485",
        "n004490",
        "n005751",
        "n004693",
        "n006662",
        "n001333",
        "n007743",
        "n005747",
        "n001936",
        "n000755",
        "n007508",
        "n003478",
        "n003123",
        "n007235",
        "n002227",
        "n007001",
        "n002102",
        "n005175",
        "n004598",
        "n006619",
        "n005414",
        "n000967",
        "n006359",
        "n007116",
        "n007207",
        "n004550",
        "n000699",
        "n005902",
        "n006352",
        "n005532",
        "n006195",
        "n007454",
        "n006047",
        "n004414",
        "n000465",
        "n004990",
        "n000632",
        "n000472",
        "n006478",
        "n004936",
        "n005323",
        "n005507",
        "n002052",
        "n005782",
        "n002782",
        "n000759",
        "n006300",
        "n000057",
        "n000818",
        "n001193",
        "n001225",
        "n003565",
        "n000903",
        "n001715",
        "n002654",
        "n005508",
        "n007208",
        "n004878",
        "n006004",
        "n004429",
        "n006408",
        "n004442",
        "n006778",
        "n007565",
        "n005567",
        "n000171",
        "n001699",
        "n003453",
        "n001693",
        "n005418",
        "n001010",
        "n005651",
        "n006012",
        "n004979",
        "n006888",
        "n001100",
        "n004418",
        "n004533",
        "n004528",
        "n000497",
        "n007124",
        "n006503",
        "n006696",
        "n000401",
        "n004893",
        "n003322",
        "n007684",
        "n004976",
        "n001642",
        "n003995",
        "n003587",
        "n001294",
        "n000964",
        "n001727",
        "n000616",
        "n000187",
        "n004511",
        "n004505",
        "n006892",
        "n004535",
        "n005311",
        "n000969",
        "n002675",
        "n004889",
        "n001484",
        "n006608",
        "n001974",
        "n001673",
        "n003283",
        "n007315",
        "n005400",
        "n000257",
        "n000613",
        "n002019",
        "n002145",
        "n004110",
        "n002538",
        "n003959",
        "n007245",
        "n000521",
        "n005476",
        "n000826",
        "n002277",
        "n004656",
        "n003383",
        "n004613",
        "n003303",
        "n005828",
        "n003865",
        "n000373",
        "n007331",
        "n004825",
        "n000637",
        "n007748",
        "n002340",
        "n006473",
        "n001775",
        "n001359",
        "n003785",
        "n005086",
        "n004471",
        "n002339",
        "n002502",
        "n004318",
        "n004231",
        "n003358",
        "n001057",
        "n007196",
        "n007726",
        "n003793",
        "n005413",
        "n003411",
        "n000638",
        "n000185",
        "n007559",
        "n003384",
        "n002621",
        "n004252",
        "n005070",
        "n001538",
        "n001547",
        "n007642",
        "n006481",
        "n000941",
        "n000979",
        "n000357",
        "n006322",
        "n004000",
        "n004666",
        "n003310",
        "n001391",
        "n004762",
        "n000776",
        "n001135",
        "n002350",
        "n000709",
        "n001042",
        "n001143",
        "n002732",
        "n003413",
        "n007332",
        "n001063",
        "n004056",
        "n006602",
        "n004565",
        "n000812",
        "n002243",
        "n001132",
        "n006944",
        "n002178",
        "n005479",
        "n004030",
        "n000488",
        "n000835",
        "n001961",
        "n002885",
        "n002086",
        "n000105",
        "n005153",
        "n000145",
        "n001566",
        "n002359",
        "n003819",
        "n003913",
        "n002947",
        "n004538",
        "n002018",
        "n002719",
        "n004313",
        "n005588",
        "n004443",
        "n003495",
        "n002255",
        "n005638",
        "n005138",
        "n006277",
        "n006590",
        "n002497",
        "n003968",
        "n007170",
        "n000579",
        "n001327",
        "n003351",
        "n006138",
        "n002452",
        "n002047",
        "n000640",
        "n005115",
        "n002789",
        "n004145",
        "n000708",
        "n004507",
        "n003374",
        "n003904",
        "n002259",
        "n003726",
        "n005415",
        "n005167",
        "n007488",
        "n007707",
        "n004655",
        "n005012",
        "n004043",
        "n004787",
        "n001748",
        "n003262",
        "n002141",
        "n000186",
        "n004422",
        "n003821",
        "n003564",
        "n000907",
        "n000461",
        "n001508",
        "n001666",
        "n003673",
        "n002278",
        "n000833",
        "n006194",
        "n000552",
        "n002066",
        "n006846",
        "n000500",
        "n005082",
        "n000992",
        "n003862",
        "n000140",
        "n000810",
        "n002864",
        "n000598",
        "n006672",
        "n005953",
        "n004747",
        "n000192",
        "n002476",
        "n005423",
        "n007579",
        "n000494",
        "n001768",
        "n002578",
        "n003831",
        "n003672",
        "n000274",
        "n003284",
        "n003946",
        "n004489",
        "n006298",
        "n006333",
        "n004331",
        "n001671",
        "n004093",
        "n005419",
        "n005982",
        "n001843",
        "n007307",
        "n003360",
        "n000530",
        "n005855",
        "n007009",
        "n003042",
        "n002720",
        "n002425",
        "n001218",
        "n001728",
        "n001056",
        "n007050",
        "n004718",
        "n003102",
        "n004559",
        "n001905",
        "n003013",
        "n004761",
        "n000816",
        "n006266",
        "n006860",
        "n002162",
        "n002366",
        "n007393",
        "n002187",
        "n005898",
        "n000610",
        "n007252",
        "n005396",
        "n004108",
        "n002573",
        "n003135",
        "n002180",
        "n006623",
        "n001788",
        "n007425",
        "n003126",
        "n005467",
        "n002815",
        "n000080",
        "n004275",
        "n002391",
        "n006824",
        "n000236",
        "n006164",
        "n002520",
        "n007540",
        "n007587",
        "n002489",
        "n007218",
        "n002872",
        "n007187",
        "n007167",
        "n007391",
        "n000758",
        "n001410",
        "n003500",
        "n004152",
        "n005318",
        "n006471",
        "n001657",
        "n005589",
        "n002215",
        "n007410",
        "n002016",
        "n005809",
        "n004949",
        "n006424",
        "n007110",
        "n003541",
        "n004653",
        "n006023",
        "n001835",
        "n004052",
        "n001780",
        "n007640",
        "n005583",
        "n000266",
        "n007077",
        "n003338",
        "n006712",
        "n006675",
        "n001121",
        "n002783",
        "n003863",
        "n000804",
        "n001523",
        "n001851",
        "n001069",
        "n002603",
        "n004844",
        "n007412",
        "n001813",
        "n003886",
        "n004119",
        "n004948",
        "n007266",
        "n002149",
        "n003838",
        "n006956",
        "n007226",
        "n001663",
        "n000167",
        "n001159",
        "n007376",
        "n000282",
        "n003619",
        "n003523",
        "n007464",
        "n000104",
        "n007144",
        "n005212",
        "n003047",
        "n005249",
        "n000083",
        "n002595",
        "n000332",
        "n007536",
        "n006426",
        "n000920",
        "n003747",
        "n006671",
        "n003508",
        "n007476",
        "n002042",
        "n003615",
        "n000876",
        "n005452",
        "n002539",
        "n006665",
        "n001799",
        "n006979",
        "n005003",
        "n007483",
        "n001263",
        "n007091",
        "n006596",
        "n007237",
        "n005891",
        "n003355",
        "n000973",
        "n005442",
        "n000673",
        "n000558",
        "n000646",
        "n001495",
        "n000399",
        "n002056",
        "n000331",
        "n000314",
        "n003257",
        "n000733",
        "n004987",
        "n000620",
        "n006442",
        "n002121",
        "n004610",
        "n006556",
        "n005014",
        "n005491",
        "n003524",
        "n000438",
        "n004408",
        "n000485",
        "n002213",
        "n001369",
        "n002829",
        "n005997",
        "n007615",
        "n000225",
        "n007163",
        "n000862",
        "n004792",
        "n007523",
        "n002977",
        "n006267",
        "n003919",
        "n004187",
        "n001028",
        "n003151",
        "n002197",
        "n004023",
        "n001511",
        "n001617",
        "n007209",
        "n006017",
        "n001360",
        "n003754",
        "n004337",
        "n001720",
        "n007747",
        "n006239",
        "n007544",
        "n004485",
        "n001094",
        "n002522",
        "n003773",
        "n001228",
        "n005985",
        "n000717",
        "n007394",
        "n007013",
        "n007277",
        "n003531",
        "n001131",
        "n007395",
        "n007007",
        "n007528",
        "n000270",
        "n006214",
        "n002462",
        "n004179",
        "n002741",
        "n004454",
        "n004263",
        "n001980",
        "n000793",
        "n004703",
        "n001548",
        "n001145",
        "n005909",
        "n004265",
        "n007704",
        "n001697",
        "n003385",
        "n000154",
        "n000203",
        "n001841",
        "n000976",
        "n000049",
        "n003799",
        "n003027",
        "n000302",
        "n001540",
        "n005671",
        "n002888",
        "n006655",
        "n000538",
        "n005533",
        "n003977",
        "n004872",
        "n001938",
        "n005009",
        "n004048",
        "n001161",
        "n005493",
        "n001592",
        "n005539",
        "n002454",
        "n005030",
        "n004591",
        "n007193",
        "n004426",
        "n007079",
        "n002498",
        "n007399",
        "n003701",
        "n003179",
        "n002597",
        "n004859",
        "n002221",
        "n002608",
        "n000960",
        "n001448",
        "n003266",
        "n001052",
        "n004060",
        "n004257",
        "n001285",
        "n005464",
        "n005449",
        "n007002",
        "n000942",
        "n001101",
        "n004542",
        "n001264",
        "n003712",
        "n006705",
        "n001281",
        "n001759",
        "n004957",
        "n005026",
        "n004710",
        "n000097",
        "n007482",
        "n004320",
        "n000264",
        "n005738",
        "n004222",
        "n000297",
        "n001647",
        "n005815",
        "n000737",
        "n005495",
        "n000847",
        "n007313",
        "n004687",
        "n003912",
        "n004193",
        "n000902",
        "n007118",
        "n003706",
        "n000378",
        "n003817",
        "n002537",
        "n007359",
        "n003178",
        "n000879",
        "n005548",
        "n002671",
        "n001235",
        "n006450",
        "n006273",
        "n004569",
        "n001109",
        "n001771",
        "n005914",
        "n006547",
        "n003764",
        "n004659",
        "n002723",
        "n002963",
        "n004368",
        "n001839",
        "n002778",
        "n000214",
        "n002036",
        "n000098",
        "n007620",
        "n006057",
        "n002037",
        "n001206",
        "n004576",
        "n000829",
        "n002865",
        "n003146",
        "n002843",
        "n001430",
        "n001860",
        "n007722",
        "n007644",
        "n001733",
        "n007134",
        "n005398",
        "n000648",
        "n001065",
        "n000429",
        "n002844",
        "n003939",
        "n003768",
        "n004510",
        "n002651",
        "n000939",
        "n001212",
        "n001849",
        "n002672",
        "n000520",
        "n003704",
        "n003194",
        "n007377",
        "n005367",
        "n007122",
        "n005501",
        "n006120",
        "n003290",
        "n005392",
        "n000061",
        "n000024",
        "n000522",
        "n000957",
        "n002240",
        "n006794",
        "n002404",
        "n006296",
        "n002619",
        "n007172",
        "n001544",
        "n003426",
        "n004071",
        "n002422",
        "n004601",
        "n004597",
        "n004005",
        "n001536",
        "n007080",
        "n000681",
        "n006878",
        "n001757",
        "n002457",
        "n005578",
        "n006479",
        "n001188",
        "n002431",
        "n001796",
        "n004420",
        "n000306",
        "n005085",
        "n005390",
        "n000019",
        "n000824",
        "n004124",
        "n006262",
        "n000066",
        "n006934",
        "n006263",
        "n001721",
        "n005988",
        "n007303",
        "n001434",
        "n001770",
        "n003676",
        "n001563",
        "n003930",
        "n007281",
        "n004001",
        "n006113",
        "n000916",
        "n005669",
        "n003724",
        "n003167",
        "n002678",
        "n005948",
        "n001712",
        "n002027",
        "n005846",
        "n003692",
        "n001680",
        "n006169",
        "n000729",
        "n004209",
        "n000032",
        "n004897",
        "n000993",
        "n004432",
        "n006354",
        "n002483",
        "n000188",
        "n006155",
        "n000707",
        "n006620",
        "n003212",
        "n006086",
        "n002683",
        "n005949",
        "n000081",
        "n000549",
        "n003926",
        "n003527",
        "n000880",
        "n000100",
        "n003708",
        "n006073",
        "n000504",
        "n006223",
        "n002689",
        "n007422",
        "n004324",
        "n006049",
        "n004134",
        "n003950",
        "n001432",
        "n002460",
        "n005050",
        "n003695",
        "n005100",
        "n007025",
        "n002297",
        "n007525",
        "n005770",
        "n004627",
        "n003916",
        "n002969",
        "n002849",
        "n006294",
        "n004894",
        "n003408",
        "n001568",
        "n006011",
        "n003071",
        "n003736",
        "n002897",
        "n000495",
        "n004002",
        "n003943",
        "n005874",
        "n006367",
        "n004821",
        "n006804",
        "n002624",
        "n004843",
        "n004156",
        "n007029",
        "n005054",
        "n005106",
        "n006055",
        "n001514",
        "n000060",
        "n005542",
        "n007254",
        "n006029",
        "n000484",
        "n004477",
        "n001926",
        "n001139",
        "n004374",
        "n006889",
        "n007135",
        "n000940",
        "n004763",
        "n004444",
        "n005779",
        "n007392",
        "n004523",
        "n005376",
        "n000990",
        "n000965",
        "n000419",
        "n006690",
        "n000528",
        "n005703",
        "n003334",
        "n000138",
        "n006440",
        "n000411",
        "n005940",
        "n006050",
        "n007618",
        "n004834",
        "n004636",
        "n003124",
        "n006033",
        "n005637",
        "n002509",
        "n002133",
        "n007663",
        "n005217",
        "n006933",
        "n003488",
        "n000469",
        "n006753",
        "n001187",
        "n003273",
        "n006342",
        "n007610",
        "n006108",
        "n006540",
        "n002516",
        "n001077",
        "n002367",
        "n002984",
        "n000603",
        "n003719",
        "n007178",
        "n002403",
        "n000462",
        "n007123",
        "n003610",
        "n006818",
        "n002328",
        "n006246",
        "n000843",
        "n002130",
        "n007468",
        "n006725",
        "n005906",
        "n001629",
        "n005191",
        "n005527",
        "n000743",
        "n002113",
        "n001920",
        "n000117",
        "n002832",
        "n007206",
        "n006911",
        "n002054",
        "n006952",
        "n001922",
        "n007348",
        "n000063",
        "n003307",
        "n005541",
        "n003875",
        "n002443",
        "n003285",
        "n003718",
        "n001241",
        "n006289",
        "n001040",
        "n001555",
        "n006145",
        "n005197",
        "n002980",
        "n002352",
        "n002330",
        "n003982",
        "n005338",
        "n002111",
        "n002025",
        "n005436",
        "n006013",
        "n003670",
        "n001491",
        "n001172",
        "n001665",
        "n005736",
        "n001828",
        "n004111",
        "n004646",
        "n002507",
        "n005283",
        "n001405",
        "n006959",
        "n004171",
        "n006394",
        "n005977",
        "n000337",
        "n004715",
        "n004092",
        "n002251",
        "n000174",
        "n001027",
        "n000650",
        "n002046",
        "n005923",
        "n006800",
        "n000215",
        "n007437",
        "n004629",
        "n002074",
        "n007272",
        "n000020",
        "n003760",
        "n002427",
        "n003576",
        "n003449",
        "n000999",
        "n002100",
        "n002327",
        "n005221",
        "n006391",
        "n007100",
        "n004973",
        "n006193",
        "n003717",
        "n006040",
        "n004503",
        "n007319",
        "n001985",
        "n002288",
        "n004369",
        "n003858",
        "n003624",
        "n003941",
        "n003651",
        "n001569",
        "n001007",
        "n003476",
        "n004643",
        "n005288",
        "n006163",
        "n006585",
        "n000347",
        "n004439",
        "n006486",
        "n006274",
        "n007174",
        "n004343",
        "n004820",
        "n006449",
        "n003228",
        "n006162",
        "n005859",
        "n001330",
        "n001696",
        "n003297",
        "n000974",
        "n002758",
        "n006088",
        "n004901",
        "n007458",
        "n003327",
        "n005901",
        "n002774",
        "n003735",
        "n003720",
        "n006722",
        "n001518",
        "n000440",
        "n006006",
        "n000860",
        "n003980",
        "n007389",
        "n005310",
        "n000336",
        "n002432",
        "n004992",
        "n006093",
        "n007470",
        "n005483",
        "n000674",
        "n005005",
        "n000588",
        "n002802",
        "n006523",
        "n004967",
        "n005469",
        "n004399",
        "n004721",
        "n006510",
        "n004188",
        "n007298",
        "n004515",
        "n001502",
        "n003439",
        "n006907",
        "n006828",
        "n000926",
        "n000653",
        "n001486",
        "n000608",
        "n006709",
        "n007388",
        "n006007",
        "n000169",
        "n001604",
        "n007176",
        "n000039",
        "n005142",
        "n007382",
        "n000022",
        "n004869",
        "n004256",
        "n001169",
        "n002132",
        "n000672",
        "n005158",
        "n007681",
        "n004585",
        "n003499",
        "n002420",
        "n002231",
        "n001627",
        "n003944",
        "n003063",
        "n000805",
        "n000561",
        "n007059",
        "n005788",
        "n003547",
        "n001844",
        "n004061",
        "n000566",
        "n003910",
        "n003474",
        "n000825",
        "n000536",
        "n007534",
        "n004651",
        "n003371",
        "n004829",
        "n001298",
        "n004547",
        "n003532",
        "n002856",
        "n003897",
        "n001993",
        "n007270",
        "n002899",
        "n004769",
        "n006625",
        "n006612",
        "n004106",
        "n005892",
        "n007083",
        "n004327",
        "n001930",
        "n004283",
        "n005605",
        "n006074",
        "n002973",
        "n007180",
        "n006764",
        "n000828",
        "n005499",
        "n001005",
        "n006182",
        "n000184",
        "n001808",
        "n005897",
        "n005930",
        "n000109",
        "n001184",
        "n002622",
        "n004390",
        "n002123",
        "n004351",
        "n005850",
        "n003556",
        "n001411",
        "n002463",
        "n001470",
        "n003674",
        "n005459",
        "n002612",
        "n003937",
        "n005933",
        "n001047",
        "n003796",
        "n005015",
        "n000668",
        "n003687",
        "n007749",
        "n004290",
        "n000163",
        "n002881",
        "n002120",
        "n005069",
        "n002667",
        "n006329",
        "n004676",
        "n006235",
        "n006221",
        "n007760",
        "n004830",
        "n007287",
        "n005992",
        "n003991",
        "n004089",
        "n005837",
        "n003070",
        "n005900",
        "n000443",
        "n004888",
        "n002898",
        "n006282",
        "n001437",
        "n003242",
        "n001713",
        "n004839",
        "n003868",
        "n001797",
        "n003117",
        "n001840",
        "n006363",
        "n006814",
        "n001904",
        "n002038",
        "n000866",
        "n004810",
        "n006720",
        "n001220",
        "n001409",
        "n005622",
        "n004445",
        "n007506",
        "n000944",
        "n001089",
        "n005010",
        "n000919",
        "n006931",
        "n002368",
        "n000393",
        "n004741",
        "n003396",
        "n001773",
        "n003716",
        "n001344",
        "n005913",
        "n002143",
        "n002919",
        "n006261",
        "n003876",
        "n005852",
        "n003210",
        "n003302",
        "n003438",
        "n005787",
        "n003282",
        "n006910",
        "n001966",
        "n000844",
        "n000563",
        "n005420",
        "n007712",
        "n002645",
        "n007581",
        "n003685",
        "n003148",
        "n000321",
        "n002338",
        "n000086",
        "n006203",
        "n000983",
        "n000483",
        "n000849",
        "n007214",
        "n003022",
        "n005540",
        "n003276",
        "n001000",
        "n004053",
        "n005441",
        "n002478",
        "n002299",
        "n003925",
        "n004456",
        "n007598",
        "n004268",
        "n003792",
        "n001688",
        "n004042",
        "n003933",
        "n004470",
        "n001480",
        "n001906",
        "n002915",
        "n000420",
        "n002730",
        "n005362",
        "n006707",
        "n003470",
        "n005907",
        "n000159",
        "n006290",
        "n005599",
        "n006962",
        "n007655",
        "n003076",
        "n000181",
        "n005371",
        "n002628",
        "n000587",
        "n003484",
        "n005007",
        "n000994",
        "n003700",
        "n004864",
        "n007203",
        "n005920",
        "n003788",
        "n001628",
        "n007591",
        "n001269",
        "n005038",
        "n006001",
        "n004174",
        "n002011",
        "n002546",
        "n007669",
        "n005107",
        "n001150",
        "n003973",
        "n007564",
        "n001520",
        "n005408",
        "n000161",
        "n007140",
        "n004745",
        "n001706",
        "n001068",
        "n006227",
        "n002026",
        "n000374",
        "n001504",
        "n003240",
        "n003086",
        "n003689",
        "n001181",
        "n005022",
        "n007177",
        "n003058",
        "n007120",
        "n000352",
        "n001414",
        "n000981",
        "n003056",
        "n001694",
        "n006058",
        "n005251",
        "n004105",
        "n005932",
        "n002999",
        "n002506",
        "n000977",
        "n003929",
        "n006506",
        "n000180",
        "n001497",
        "n007291",
        "n000417",
        "n000064",
        "n002648",
        "n007276",
        "n007262",
        "n003940",
        "n005649",
        "n001367",
        "n001675",
        "n005466",
        "n006945",
        "n004407",
        "n004529",
        "n004615",
        "n004255",
        "n002004",
        "n004452",
        "n001521",
        "n002588",
        "n001873",
        "n005287",
        "n002394",
        "n005708",
        "n005830",
        "n006912",
        "n001738",
        "n004599",
        "n004924",
        "n002593",
        "n006330",
        "n004805",
        "n000676",
        "n006414",
        "n002533",
        "n001717",
        "n006009",
        "n002900",
        "n002584",
        "n000943",
        "n006885",
        "n002785",
        "n004266",
        "n003833",
        "n002292",
        "n004139",
        "n005579",
        "n001729",
        "n001413",
        "n000013",
        "n002438",
        "n006137",
        "n003099",
        "n000456",
        "n003147",
        "n002150",
        "n005721",
        "n000770",
        "n001595",
        "n001701",
        "n003962",
        "n000745",
        "n001551",
        "n003581",
        "n002097",
        "n007342",
        "n000938",
        "n007293",
        "n001436",
        "n005971",
        "n002738",
        "n005265",
        "n006704",
        "n006310",
        "n007309",
        "n002144",
        "n005129",
        "n003239",
        "n005868",
        "n007590",
        "n004518",
        "n002500",
        "n002122",
        "n005829",
        "n005229",
        "n007333",
        "n004392",
        "n001496",
        "n002966",
        "n002547",
        "n002837",
        "n003814",
        "n001236",
        "n003235",
        "n000593",
        "n005944",
        "n006035",
        "n006897",
        "n006877",
        "n003325",
        "n005284",
        "n000796",
        "n000175",
        "n007010",
        "n004218",
        "n007046",
        "n004849",
        "n001567",
        "n005842",
        "n003264",
        "n003143",
        "n007011",
        "n003142",
        "n006320",
        "n002484",
        "n002207",
        "n007195",
        "n002387",
        "n005263",
        "n006399",
        "n006759",
        "n004178",
        "n007575",
        "n006045",
        "n002646",
        "n005857",
        "n004090",
        "n002501",
        "n000629",
        "n005260",
        "n000491",
        "n003909",
        "n005130",
        "n007665",
        "n005745",
        "n001106",
        "n005360",
        "n006321",
        "n006616",
        "n004753",
        "n005099",
        "n006984",
        "n005228",
        "n006972",
        "n005657",
        "n000479",
        "n007551",
        "n000589",
        "n001572",
        "n005996",
        "n003434",
        "n000050",
        "n001038",
        "n002272",
        "n007074",
        "n000817",
        "n002308",
        "n006592",
        "n002190",
        "n001254",
        "n005279",
        "n007433",
        "n001585",
        "n000268",
        "n003170",
        "n004724",
        "n007040",
        "n005847",
        "n004223",
        "n006654",
        "n000012",
        "n006546",
        "n005457",
        "n001309",
        "n007666",
        "n006564",
        "n003981",
        "n004396",
        "n003749",
        "n004902",
        "n007645",
        "n006613",
        "n003348",
        "n003295",
        "n000108",
        "n000715",
        "n002348",
        "n007491",
        "n006498",
        "n001615",
        "n000795",
        "n004273",
        "n005239",
        "n002174",
        "n003870",
        "n003660",
        "n000244",
        "n003932",
        "n002494",
        "n005805",
        "n004648",
        "n005437",
        "n002709",
        "n006535",
        "n006693",
        "n003428",
        "n001834",
        "n006148",
        "n002031",
        "n004317",
        "n001608",
        "n007057",
        "n000353",
        "n005653",
        "n004790",
        "n000720",
        "n001652",
        "n006069",
        "n005737",
        "n001483",
        "n005876",
        "n003822",
        "n001944",
        "n004561",
        "n001959",
        "n006254",
        "n006349",
        "n003729",
        "n006865",
        "n007421",
        "n003004",
        "n006639",
        "n000712",
        "n006335",
        "n000513",
        "n001329",
        "n003908",
        "n002281",
        "n004189",
        "n002015",
        "n001226",
        "n005345",
        "n007440",
        "n001809",
        "n001550",
        "n007734",
        "n003542",
        "n006002",
        "n004133",
        "n005509",
        "n005431",
        "n002729",
        "n000492",
        "n003887",
        "n002220",
        "n000614",
        "n005593",
        "n002406",
        "n007546",
        "n006595",
        "n007217",
        "n005250",
        "n001856",
        "n002408",
        "n001646",
        "n004107",
        "n001702",
        "n004014",
        "n003391",
        "n001219",
        "n000626",
        "n006431",
        "n000722",
        "n007283",
        "n004167",
        "n001670",
        "n005343",
        "n005646",
        "n002804",
        "n007343",
        "n004809",
        "n004132",
        "n003342",
        "n005843",
        "n002949",
        "n006242",
        "n004098",
        "n001348",
        "n005989",
        "n001459",
        "n004079",
        "n007302",
        "n007658",
        "n003616",
        "n007271",
        "n000908",
        "n005056",
        "n004549",
        "n002165",
        "n004026",
        "n003347",
        "n001322",
        "n000329",
        "n005608",
        "n006130",
        "n006988",
        "n005575",
        "n005878",
        "n002388",
        "n004954",
        "n001019",
        "n003336",
        "n003315",
        "n007311",
        "n005103",
        "n004683",
        "n005430",
        "n006209",
        "n003501",
        "n007357",
        "n000243",
        "n004916",
        "n001397",
        "n003986",
        "n002571",
        "n003748",
        "n003216",
        "n000065",
        "n005717",
        "n006511",
        "n000344",
        "n002909",
        "n006969",
        "n006133",
        "n006938",
        "n004487",
        "n007507",
        "n001858",
        "n002112",
        "n005383",
        "n001772",
        "n007081",
        "n003883",
        "n002008",
        "n000318",
        "n007065",
        "n002661",
        "n007647",
        "n000652",
        "n003516",
        "n003422",
        "n006965",
        "n005206",
        "n002965",
        "n002242",
        "n003392",
        "n003106",
        "n002252",
        "n002360",
        "n001119",
        "n006248",
        "n005176",
        "n004412",
        "n000249",
        "n004537",
        "n005391",
        "n000735",
        "n005020",
        "n005854",
        "n004713",
        "n006527",
        "n000426",
        "n005440",
        "n004667",
        "n006234",
        "n006444",
        "n007006",
        "n003857",
        "n001848",
        "n004781",
        "n007623",
        "n003366",
        "n004149",
        "n003922",
        "n000869",
        "n004791",
        "n006850",
        "n006791",
        "n001887",
        "n004460",
        "n001009",
        "n006366",
        "n007511",
        "n000873",
        "n000524",
        "n000275",
        "n005394",
        "n007168",
        "n004880",
        "n004375",
        "n000272",
        "n005397",
        "n000220",
        "n001924",
        "n005572",
        "n001795",
        "n004311",
        "n003067",
        "n003003",
        "n000286",
        "n002229",
        "n007738",
        "n000216",
        "n004448",
        "n001472",
        "n005946",
        "n001162",
        "n002156",
        "n001287",
        "n006303",
        "n001510",
        "n006519",
        "n006862",
        "n005253",
        "n005645",
        "n003492",
        "n003154",
        "n004083",
        "n003742",
        "n001744",
        "n006253",
        "n004016",
        "n002241",
        "n000788",
        "n001805",
        "n006346",
        "n003787",
        "n000036",
        "n001684",
        "n003918",
        "n000606",
        "n001026",
        "n001476",
        "n002364",
        "n007408",
        "n007432",
        "n003486",
        "n007012",
        "n000150",
        "n007330",
        "n005663",
        "n004401",
        "n006264",
        "n002988",
        "n001326",
        "n007519",
        "n002007",
        "n000076",
        "n005780",
        "n004855",
        "n002135",
        "n002606",
        "n006947",
        "n004027",
        "n006412",
        "n000685",
        "n004125",
        "n003613",
        "n006160",
        "n005514",
        "n000466",
        "n002203",
        "n007493",
        "n004951",
        "n003060",
        "n003757",
        "n000262",
        "n004321",
        "n002096",
        "n006997",
        "n001419",
        "n005718",
        "n005631",
        "n003680",
        "n006684",
        "n002822",
        "n006413",
        "n007465",
        "n002118",
        "n004476",
        "n002967",
        "n003050",
        "n005610",
        "n001155",
        "n000204",
        "n005929",
        "n004881",
        "n000158",
        "n001623",
        "n005502",
        "n004182",
        "n000529",
        "n004876",
        "n001033",
        "n006816",
        "n000449",
        "n003159",
        "n000176",
        "n002544",
        "n006386",
        "n003617",
        "n000067",
        "n006919",
        "n000376",
        "n005053",
        "n006729",
        "n002779",
        "n004736",
        "n006636",
        "n002293",
        "n004160",
        "n005596",
        "n005327",
        "n004919",
        "n000702",
        "n007447",
        "n001461",
        "n005285",
        "n003028",
        "n004835",
        "n001234",
        "n006375",
        "n001356",
        "n005198",
        "n005618",
        "n006265",
        "n006400",
        "n001915",
        "n006494",
        "n007243",
        "n007049",
        "n000724",
        "n007576",
        "n003121",
        "n004295",
        "n002028",
        "n002752",
        "n005369",
        "n000333",
        "n003658",
        "n001408",
        "n001165",
        "n003271",
        "n003311",
        "n002560",
        "n003657",
        "n003073",
        "n005455",
        "n000783",
        "n003082",
        "n001753",
        "n006287",
        "n006048",
        "n007250",
        "n002290",
        "n000490",
        "n006318",
        "n004364",
        "n001223",
        "n000751",
        "n007763",
        "n007115",
        "n007280",
        "n007155",
        "n001501",
        "n004735",
        "n002994",
        "n007230",
        "n006845",
        "n005451",
        "n000604",
        "n003779",
        "n001689",
        "n002882",
        "n002017",
        "n002175",
        "n006020",
        "n000932",
        "n004301",
        "n000131",
        "n006701",
        "n005127",
        "n005595",
        "n007165",
        "n004602",
        "n003029",
        "n003425",
        "n004587",
        "n001381",
        "n005571",
        "n004359",
        "n003279",
        "n001387",
        "n000819",
        "n006306",
        "n000888",
        "n001901",
        "n001489",
        "n004114",
        "n001316",
        "n002853",
        "n004328",
        "n005591",
        "n001790",
        "n001310",
        "n006559",
        "n006461",
        "n006152",
        "n005766",
        "n002910",
        "n004481",
        "n007750",
        "n005987",
        "n003671",
        "n003746",
        "n004785",
        "n002136",
        "n006003",
        "n001602",
        "n001606",
        "n000837",
        "n002423",
        "n004308",
        "n005077",
        "n004049",
        "n006200",
        "n006297",
        "n002060",
        "n003623",
        "n004037",
        "n004640",
        "n003308",
        "n001734",
        "n003222",
        "n001731",
        "n007023",
        "n000630",
        "n005432",
        "n005967",
        "n007191",
        "n005016",
        "n000006",
        "n001015",
        "n007161",
        "n002577",
        "n001754",
        "n004671",
        "n001644",
        "n007222",
        "n004620",
        "n007264",
        "n000387",
        "n003077",
        "n007566",
        "n006275",
        "n001088",
        "n005990",
        "n007452",
        "n000164",
        "n005021",
        "n006787",
        "n003751",
        "n001325",
        "n007257",
        "n007198",
        "n006423",
        "n006551",
        "n001931",
        "n002691",
        "n007317",
        "n007051",
        "n002870",
        "n002614",
        "n000564",
        "n006708",
        "n004711",
        "n001911",
        "n002767",
        "n001760",
        "n000305",
        "n001659",
        "n002204",
        "n001396",
        "n001821",
        "n001080",
        "n006766",
        "n000905",
        "n002611",
        "n005426",
        "n001006",
        "n006960",
        "n004215",
        "n004345",
        "n000984",
        "n000103",
        "n002039",
        "n004868",
        "n001963",
        "n001690",
        "n007279",
        "n000418",
        "n000884",
        "n002461",
        "n004415",
        "n000124",
        "n005443",
        "n002397",
        "n006721",
        "n006743",
        "n001460",
        "n001189",
        "n001345",
        "n000023",
        "n002987",
        "n001380",
        "n001541",
        "n003184",
        "n002160",
        "n004087",
        "n003682",
        "n004764",
        "n004689",
        "n001814",
        "n007114",
        "n004197",
        "n005538",
        "n003947",
        "n005453",
        "n005869",
        "n003618",
        "n002234",
        "n005789",
        "n002744",
        "n006406",
        "n004548",
        "n006019",
        "n003444",
        "n004690",
        "n006615",
        "n007314",
        "n005264",
        "n000918",
        "n001714",
        "n000827",
        "n004512",
        "n001747",
        "n005912",
        "n004104",
        "n004287",
        "n004506",
        "n003346",
        "n007354",
        "n002640",
        "n006644",
        "n002400",
        "n006579",
        "n002929",
        "n001379",
        "n000241",
        "n006328",
        "n003593",
        "n000747",
        "n000863",
        "n000365",
        "n000591",
        "n001698",
        "n004900",
        "n003646",
        "n007304",
        "n005465",
        "n005477",
        "n003517",
        "n006392",
        "n001122",
        "n000741",
        "n000663",
        "n006779",
        "n006177",
        "n002850",
        "n003650",
        "n000157",
        "n005401",
        "n000151",
        "n001955",
        "n005628",
        "n002155",
        "n000120",
        "n006483",
        "n006668",
        "n002117",
        "n004097",
        "n004126",
        "n002295",
        "n005925",
        "n001464",
        "n007267",
        "n003323",
        "n006844",
        "n003906",
        "n004536",
        "n004264",
        "n007076",
        "n000111",
        "n004019",
        "n007630",
        "n007510",
        "n002526",
        "n005688",
        "n004371",
        "n001268",
        "n004654",
        "n006683",
        "n000789",
        "n000058",
        "n006774",
        "n001305",
        "n005849",
        "n006827",
        "n003040",
        "n005568",
        "n003291",
        "n004994",
        "n002345",
        "n005266",
        "n006820",
        "n002318",
        "n002225",
        "n000087",
        "n000899",
        "n004612",
        "n000756",
        "n002586",
        "n002739",
        "n003353",
        "n003885",
        "n003139",
        "n007305",
        "n005269",
        "n006382",
        "n005196",
        "n002265",
        "n002426",
        "n001861",
        "n001493",
        "n003229",
        "n005938",
        "n002444",
        "n002771",
        "n007018",
        "n007337",
        "n002115",
        "n005551",
        "n003637",
        "n004428",
        "n002552",
        "n006037",
        "n002940",
        "n006059",
        "n004572",
        "n001442",
        "n003416",
        "n007242",
        "n001102",
        "n004446",
        "n003223",
        "n000227",
        "n006085",
        "n000582",
        "n005235",
        "n001589",
        "n007132",
        "n007063",
        "n002465",
        "n006042",
        "n001637",
        "n007688",
        "n002558",
        "n000611",
        "n000221",
        "n003157",
        "n006072",
        "n007427",
        "n005919",
        "n002570",
        "n001939",
        "n006549",
        "n007481",
        "n004141",
        "n000444",
        "n002464",
        "n002262",
        "n002437",
        "n005560",
        "n000322",
        "n000206",
        "n000288",
        "n001600",
        "n000277",
        "n000508",
        "n003293",
        "n001328",
        "n004582",
        "n005761",
        "n007213",
        "n001726",
        "n000639",
        "n001707",
        "n007153",
        "n003253",
        "n001641",
        "n004704",
        "n007225",
        "n005178",
        "n003177",
        "n005684",
        "n007366",
        "n004700",
        "n000238",
        "n004997",
    ]


class VGGFace2Dataset(FaceDataset):
    """
    A wrapper on a Multiclass Dataset specifically for VGGFace2 images.
    """

    @staticmethod
    def construct(
        data_directory: Union[str, Path],
        researchers_directory: Union[str, Path],
        size: FaceDatasetSize,
        class_image_limit: int,
        convert_to_bgr: bool = True,
    ) -> "FaceDataset":
        return VGGFace2Dataset(
            data_directory,
            researchers_directory,
            size,
            class_image_limit,
            convert_to_bgr,
        )

    def __init__(
        self,
        data_directory: Union[str, Path],
        researchers_directory: Union[str, Path],
        size: FaceDatasetSize,
        class_image_limit: int,
        convert_to_bgr: bool = True,
        data: Optional[List[Tuple[torch.Tensor, int]]] = None,
        class_index_map: Optional[Dict[str, int]] = None,
    ) -> None:
        """
        Initialise a VGGFace2 dataset with the given data directory and researcher directory
        for the VGGFace2 and researchers images respectively.

        :param data_directory: The directory containing the VGGFace2 images.
        :param researchers_directory: The directory containing the researcher images.
        :param size: The size of the VGGFace2 dataset to load.
        :param class_image_limit: The maximum number of images per class.
        :param convert_to_bgr: Convert the images to BGR (default is True).
        :param data: The data to load in.
        :param class_index_map: The mapper from class name to index.
        """
        super().__init__(class_image_limit, data, class_index_map, convert_to_bgr)
        self.__data_directory = data_directory
        self.__researchers_directory = researchers_directory
        self.__size = size

        if data is None and class_index_map is None:
            self.load_data(data_directory, size.dataset_names)
            self.load_data(researchers_directory, RESEARCHERS)

    def split_training_testing(
        self,
        training_ratio: Optional[float] = None,
        training_image_limit: Optional[int] = TRAINING_IMAGE_LIMIT,
        testing_image_limit: Optional[int] = TESTING_IMAGE_LIMIT,
    ) -> Tuple["VGGFace2Dataset", "VGGFace2Dataset"]:
        # Store the images per class
        image_classes = {}
        for image, clazz in self._data:
            if clazz in image_classes.keys():
                image_classes[clazz].append((image, clazz))
            else:
                image_classes[clazz] = [(image, clazz)]

        training_data = []
        testing_data = []

        # Split the data for each class
        for clazz, data in image_classes.items():
            training, testing = split_data(
                data, training_ratio, training_image_limit, testing_image_limit
            )
            training_data.extend(training)
            testing_data.extend(testing)

        return VGGFace2Dataset(
            self.__data_directory,
            self.__researchers_directory,
            self.__size,
            training_image_limit,
            self.convert_to_bgr,
            training_data,
            self._class_index_map,
        ), VGGFace2Dataset(
            self.__data_directory,
            self.__researchers_directory,
            self.__size,
            testing_image_limit,
            self.convert_to_bgr,
            testing_data,
            self._class_index_map,
        )

    def split_training_testing_as_loader(
        self,
        batch_size: int,
        training_ratio: Optional[float] = None,
        training_image_limit: Optional[int] = TRAINING_IMAGE_LIMIT,
        testing_image_limit: Optional[int] = TESTING_IMAGE_LIMIT,
    ) -> Tuple[DataLoader, DataLoader]:
        return super().split_training_testing_as_loader(
            batch_size, training_ratio, training_image_limit, testing_image_limit
        )
