import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.autograd import Variable

def trades_loss(model, x_natural, y, optimizer, step_size=0.003, epsilon=0.031,
                    perturb_steps=10, beta=1.0, distance='l_inf', loss = 'trades', 
                    BNeval=True):
    # define KL-loss
    if loss == 'trades':
        criterion_loss = nn.KLDivLoss(size_average=False)
    else:
        raise RuntimeError('No exsiting current loss')
    if BNeval:
        model.eval()
    batch_size = len(x_natural)
    # generate adversarial example
    x_adv = x_natural.detach() + 0.001 * torch.randn(x_natural.shape).cuda().detach()
    if distance == 'l_inf':
        for _ in range(perturb_steps):
            x_adv.requires_grad_()
            with torch.enable_grad():
                if loss == 'trades':
                    loss_c = criterion_loss(F.log_softmax(model(x_adv), dim=1),
                                        F.softmax(model(x_natural), dim=1))
                else:
                    raise RuntimeError('A error occurred')

            grad = torch.autograd.grad(loss_c, [x_adv])[0]
            x_adv = x_adv.detach() + step_size * torch.sign(grad.detach())
            x_adv = torch.min(torch.max(x_adv, x_natural - epsilon), x_natural + epsilon)
            x_adv = torch.clamp(x_adv, 0.0, 1.0)
    else:
        x_adv = torch.clamp(x_adv, 0.0, 1.0)
    if BNeval:
        model.train()

    x_adv = Variable(torch.clamp(x_adv, 0.0, 1.0), requires_grad=False)
    # zero gradient
    optimizer.zero_grad()
    # calculate robust loss
    logits = model(x_natural)
    logits_adv = model(x_adv)
    
    if loss=='trades':
        loss_natural = F.cross_entropy(logits, y)
        loss_robust = (1.0 / batch_size) * criterion_loss(F.log_softmax(logits_adv, dim=1),
                                                    F.softmax(logits, dim=1))
        loss = loss_natural + beta * loss_robust
    else:
        raise RuntimeError('A error occurred')
    return loss
