<div align="center">

# Entering the Era of Discrete Diffusion Models: A Benchmark for Schrödinger Bridges and Entropic Optimal Transport

</div>

## 🗂️ Repository structure

```bash
|-- configs     # hydra configs
|-- logs        # experiment logs
|-- notebooks   # experiments & analysis
`-- src         
    |-- bench   # bencmark package code
    |-- data    # lightning datamodules
    |-- methods # e.g. CSBM, DLightSB, etc.
    |-- metrics # non-benchmark metrics
    |-- utils   # e.g. for logging, data
    `-- run.py  # main entrypoint for training & testing
```

## 📦 Dependencies

Create the Anaconda environment using the following command:

```bash
conda env update -f environment.yml
```

## 🏋️‍♂️ Training

For training look for desired experiment in `configs/experiment` and pass it as an argument to the following command:

```bash
python -m src.run experiment=csbm_gaussian_to_swiss_roll
```

## 📊 Evaluation

For evaluation, follow the training instructions, but set `task_name=test` and specify the checkpoint path `ckpt_path`:

```bash
python -m src.run experiment=csbm_gaussian_to_swiss_roll task_name=test ckpt_path=<path>
```
