### Some instructions on using the ESL specification language
1. **Reserved** **keywords**: `True`, `False`.

2. **For the JSON file encoding the rules** , the following symbols are reserved with specified logical meanings:
   `{&, |, ~, =>, (, )}` correspond to `{and, or, negation, implies, brackets}`;

3. **No spaces** should be used in variable or predicate names; Only `[a-z, A-Z, _]` are allowed;

4. **Each variable name must start with a lowercase letter**;

5. **Each predicate name must start with an uppercase letter** ;

6. **Each rule must be in the form of** : `"? => ?"`;

7. **Every newly introduced free variable must appear independently at least once on the left-hand side (LHS)** of the rule.
  
   Example:
   - ❌ Invalid: `A(x, y) & B(x*z, y) => C(x, y*z)` — `z` appears for the first time inside a compound expression `x*z`, but not as a standalone variable.
   - ✅ Valid: `A(x, y) & B(m, y) => C(x, y*m/x)` — `m` appears independently on the LHS.

8. **Free variables must appear independently before being used in compound expressions.**

   Example:

   - ❌ Invalid: `A(x, y) & ~ B(z*x, y) => C(y, z)` — `z` appears for the first time inside a compound term `z*x`, which is not allowed.
   - ✅ Valid: `A(x, y) & ~ B(m, y) => C(y, m/x)` — `m` appears independently on the LHS.

9. It is **not valid** for a free variable to appear **for the first time** on the right-hand side (RHS) of a rule.
  
   Example:
   - ❌ Invalid: `A(x) => B(y)` — `y` appears for the first time on the RHS and was not previously defined on the LHS.
   - ✅ Valid: `A(x) => B(x)`

### To run the code

Please install packages according to the `requirements.txt`

```shell
# Please setting up: --target_model, --target_api_key, --target_base_url, --perception_model, --perception_api_key, --perception_base_url
# These configurations can be set up either via commands or by inserting the corresponding code.

# Test case study 1: Singapore Rapid Transit Systems Act, Type-2: Smoking
python main.py --inter_level 1 --CS 1 --domain mrt --sub_domain Smoking --api_timeout 60

# Test case study 2: Numerical comparison
python main.py --inter_level 2 --CS 2 --domain comp --api_timeout 60

# Test case study 3: Inequality solving
python main.py --inter_level 1 --CS 3 --domain ineq --sub_domain factorization --api_timeout 60
```