# MoralSim
This repository provides the code for the simulation in src/moralsim as well as for the analysis of the results in notebooks. The simulation adapts and extends the [GovSim](https://github.com/giorgiopiatti/GovSim) framework including the pathfinder library for LLM inference.


## Code Setup
To use the codes in this repo, first clone this repo:

Then, to install the dependencies, run the following command if you want to use API models without GPU only.
    
```setup
bash ./setup.sh
```

if you want to use GPUs via the `transformers` library, run the following command:

```setup
bash ./setup_transformers.sh
```

or if you want to use GPUs via the `vllm` library, run the following command:

```setup
bash ./setup_vllm.sh
```

All setups scripts require conda to be installed. If you do not have conda installed, you can install it by following the instructions [here](https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html).


## Instructions
An example script for running the simulation can be found in ``example_run.sh``. It requires a Weights and Biases account. The notebooks for analysing the results can be run as is.
