import numpy as np
EPS = 1e-8

def un_normalize_data(Xn, min_max_stats):
    mn = min_max_stats[:, 0]
    mx = min_max_stats[:, 1]

    X = Xn.copy()
    # Normalize feature dimensions independently
    for i in range(Xn.shape[2]):
        Xt = Xn[:, :, i] * (EPS + mx - mn) + mn
        X[:, :, i] = Xt

    return X


def normalize_data(X, min_max_stats, target_min=-1, target_max=1):

    mn = min_max_stats[:, 0]
    mx = min_max_stats[:, 1]

    Xn = X.copy()
    # Normalize feature dimensions independently
    for i in range(X.shape[2]):
        Xt = X[:, :, i]
        Xt = (Xt - mn[i]) / (EPS + mx[i] - mn[i])
        Xt = Xt * (target_max - target_min) + target_min
        Xn[:, :, i] = Xt

    return Xn


def standardize_data(X, mu_sigma_stats):

    mu = mu_sigma_stats[:, 0]
    sigma = mu_sigma_stats[:, 1]

    Xn = X.copy()
    # Normalize feature dimensions independently
    for i in range(X.shape[2]):
        Xt = X[:, :, i]
        Xt = (Xt - mu[i]) / (EPS + sigma[i])
        Xn[:, :, i] = Xt

    return Xn


def transform_data(X, data_stats, standardize_str=None):

    if(standardize_str=='mu_sigma'):
        Xn = standardize_data(X, data_stats)
    elif(standardize_str=='min_max'):
        Xn = normalize_data(X, data_stats)
    else:
        Xn = X

    return Xn

def transform_data_to_markovian(X):
    N = X.shape[0]
    L = X.shape[1]
    Fn = L-1

    Xn = np.zeros((N,L,Fn))
    for i in range(1,L):
        Xn[:, i, :i] = X[:, 1:i+1, 0]

    return Xn
