import numpy as np

def get_ec_cost_components(stop_idxs, preds, y_true, L):
    y_pred = np.argmax(preds, axis=2)
    perr = np.mean(y_true != y_pred[np.arange(y_pred.shape[0]), stop_idxs])
    eps = np.mean(stop_idxs+1)/L
    return perr, eps

def calculate_stopping_reward(th, y_pred, rewards):

    L = rewards.shape[1]
    interventions = (y_pred >= th) * 1
    J = np.argmax(interventions > 0.5, axis=1)
    Jind = np.amax((interventions > 0.5) * 1, axis=1)
    reward_idxs = J + (L-1) * (Jind == 0)
    stopping_reward = np.mean(rewards[np.arange(y_pred.shape[0]), reward_idxs])

    return stopping_reward, reward_idxs

def classification_cost(preds, labels, L):
    pred_class = np.argmax(preds, axis=2)
    true_class = (np.tile(np.expand_dims(labels, axis=1), (1, L))) * 1
    ece_cost = (pred_class != true_class) * 1
    return ece_cost
